/*
 * Decompiled with CFR 0.152.
 */
package org.jabref;

import java.awt.Font;
import java.io.File;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.FontUIResource;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.GUIGlobals;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.dialogs.BackupUIManager;
import org.jabref.gui.importer.ParserResultWarningDialog;
import org.jabref.gui.importer.actions.OpenDatabaseAction;
import org.jabref.gui.shared.SharedDatabaseUIManager;
import org.jabref.gui.worker.VersionWorker;
import org.jabref.logic.autosaveandbackup.BackupManager;
import org.jabref.logic.importer.OpenDatabase;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.shared.exception.InvalidDBMSConnectionPropertiesException;
import org.jabref.logic.shared.exception.NotASharedDatabaseException;
import org.jabref.logic.util.OS;
import org.jabref.logic.util.Version;
import org.jabref.model.database.shared.DatabaseNotSupportedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JabRefGUI {
    private static final String NIMBUS_LOOK_AND_FEEL = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
    private static final Logger LOGGER = LoggerFactory.getLogger(JabRefGUI.class);
    private static final String GTK_LF_CLASSNAME = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    private static JabRefFrame mainFrame;
    private final List<ParserResult> bibDatabases;
    private final boolean isBlank;
    private final List<ParserResult> failed = new ArrayList<ParserResult>();
    private final List<ParserResult> toOpenTab = new ArrayList<ParserResult>();
    private final String focusedFile;

    public JabRefGUI(List<ParserResult> argsDatabases, boolean isBlank) {
        this.bibDatabases = argsDatabases;
        this.isBlank = isBlank;
        this.focusedFile = argsDatabases.stream().findFirst().flatMap(ParserResult::getFile).map(File::getAbsolutePath).orElse(Globals.prefs.get("lastFocused"));
        this.openWindow();
        JabRefGUI.checkForNewVersion(false);
    }

    public static void checkForNewVersion(boolean manualExecution) {
        Version toBeIgnored = Globals.prefs.getVersionPreferences().getIgnoredVersion();
        Version currentVersion = Globals.BUILD_INFO.getVersion();
        new VersionWorker(JabRefGUI.getMainFrame(), manualExecution, currentVersion, toBeIgnored).execute();
    }

    /*
     * WARNING - void declaration
     */
    private void openWindow() {
        void var3_11;
        if (OS.OS_X) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        System.setProperty("swing.aatext", "true");
        System.setProperty("awt.useSystemAAFontSettings", "lcd");
        this.setLookAndFeel();
        if (!this.isBlank && Globals.prefs.getBoolean("openLastEdited")) {
            this.openLastEditedDatabases();
        }
        GUIGlobals.init();
        LOGGER.debug("Initializing frame");
        mainFrame = new JabRefFrame();
        boolean first = false;
        if (!this.bibDatabases.isEmpty()) {
            Iterator<ParserResult> parserResultIterator = this.bibDatabases.iterator();
            while (parserResultIterator.hasNext()) {
                ParserResult parserResult = parserResultIterator.next();
                if (parserResult.getFile().filter(path -> path.getAbsolutePath().equals(this.focusedFile)).isPresent()) {
                    first = true;
                }
                if (parserResult.isInvalid()) {
                    this.failed.add(parserResult);
                    parserResultIterator.remove();
                    continue;
                }
                if (parserResult.getDatabase().isShared()) {
                    try {
                        new SharedDatabaseUIManager(mainFrame).openSharedDatabaseFromParserResult(parserResult);
                    }
                    catch (SQLException | InvalidDBMSConnectionPropertiesException | NotASharedDatabaseException | DatabaseNotSupportedException e) {
                        parserResult.getDatabaseContext().clearDatabaseFile();
                        parserResult.getDatabase().clearSharedDatabaseID();
                        LOGGER.error("Connection error", e);
                        JOptionPane.showMessageDialog(mainFrame, e.getMessage() + "\n\n" + Localization.lang("A local copy will be opened.", new String[0]), Localization.lang("Connection error", new String[0]), 2);
                    }
                    this.toOpenTab.add(parserResult);
                    continue;
                }
                if (parserResult.toOpenTab()) {
                    this.toOpenTab.add(parserResult);
                    continue;
                }
                JabRefGUI.getMainFrame().addParserResult(parserResult, first);
                first = false;
            }
        }
        for (ParserResult parserResult : this.toOpenTab) {
            JabRefGUI.getMainFrame().addParserResult(parserResult, first);
            first = false;
        }
        if (Globals.prefs.getBoolean("windowMaximised")) {
            JabRefGUI.getMainFrame().setExtendedState(6);
        }
        JabRefGUI.getMainFrame().setVisible(true);
        for (ParserResult parserResult : this.failed) {
            String message = "<html>" + Localization.lang("Error opening file '%0'.", parserResult.getFile().get().getName()) + "<p>" + parserResult.getErrorMessage() + "</html>";
            JOptionPane.showMessageDialog(JabRefGUI.getMainFrame(), message, Localization.lang("Error opening file", new String[0]), 0);
        }
        int tabNumber = 0;
        for (ParserResult pr : this.bibDatabases) {
            ParserResultWarningDialog.showParserResultWarningDialog(pr, JabRefGUI.getMainFrame(), tabNumber++);
        }
        boolean bl = false;
        while (var3_11 < this.bibDatabases.size() && var3_11 < JabRefGUI.getMainFrame().getBasePanelCount()) {
            ParserResult pr;
            pr = this.bibDatabases.get((int)var3_11);
            BasePanel panel = JabRefGUI.getMainFrame().getBasePanelAt((int)var3_11);
            OpenDatabaseAction.performPostOpenActions(panel, pr);
            ++var3_11;
        }
        LOGGER.debug("Finished adding panels");
        if (!this.bibDatabases.isEmpty()) {
            JabRefGUI.getMainFrame().getCurrentBasePanel().getMainTable().requestFocus();
        }
    }

    private void openLastEditedDatabases() {
        if (Globals.prefs.get("lastEdited") == null) {
            return;
        }
        List<String> lastFiles = Globals.prefs.getStringList("lastEdited");
        for (String fileName : lastFiles) {
            ParserResult parsedDatabase;
            File dbFile = new File(fileName);
            if (this.isLoaded(dbFile) || !dbFile.exists()) continue;
            if (BackupManager.checkForBackupFile(dbFile.toPath())) {
                BackupUIManager.showRestoreBackupDialog(mainFrame, dbFile.toPath());
            }
            if ((parsedDatabase = OpenDatabase.loadDatabase(fileName, Globals.prefs.getImportFormatPreferences(), Globals.getFileUpdateMonitor())).isEmpty()) {
                LOGGER.error(Localization.lang("Error opening file", new String[0]) + " '" + dbFile.getPath() + "'");
                continue;
            }
            this.bibDatabases.add(parsedDatabase);
        }
    }

    private boolean isLoaded(File fileToOpen) {
        for (ParserResult pr : this.bibDatabases) {
            if (!pr.getFile().isPresent() || !pr.getFile().get().equals(fileToOpen)) continue;
            return true;
        }
        return false;
    }

    private void setLookAndFeel() {
        try {
            String lookFeel;
            String systemLookFeel = UIManager.getSystemLookAndFeelClassName();
            if (Globals.prefs.getBoolean("useDefaultLookAndFeel")) {
                if (GTK_LF_CLASSNAME.equals(systemLookFeel)) {
                    lookFeel = NIMBUS_LOOK_AND_FEEL;
                    LOGGER.warn("There seems to be problems with GTK Look&Feel. Using Nimbus L&F instead. Change to another L&F with caution.");
                } else {
                    lookFeel = systemLookFeel;
                }
            } else {
                lookFeel = Globals.prefs.get("lookAndFeel");
            }
            if (UIManager.getCrossPlatformLookAndFeelClassName().equals(lookFeel)) {
                UIManager.setLookAndFeel(NIMBUS_LOOK_AND_FEEL);
            } else {
                try {
                    UIManager.setLookAndFeel(lookFeel);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                    UIManager.setLookAndFeel(systemLookFeel);
                    Globals.prefs.put("lookAndFeel", systemLookFeel);
                    JOptionPane.showMessageDialog(JabRefGUI.getMainFrame(), Localization.lang("Unable to find the requested look and feel and thus the default one is used.", new String[0]), Localization.lang("Warning", new String[0]), 2);
                    LOGGER.warn("Unable to find requested look and feel", e);
                }
            }
            if (Globals.prefs.getBoolean("fxFontRenderingTweak")) {
                System.setProperty("prism.text", "t2k");
                System.setProperty("prism.lcdtext", "true");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Look and feel could not be set", e);
        }
        boolean overrideDefaultFonts = Globals.prefs.getBoolean("overrideDefaultFonts");
        if (overrideDefaultFonts) {
            int fontSize = Globals.prefs.getInt("menuFontSize");
            UIDefaults defaults = UIManager.getDefaults();
            Enumeration keys = defaults.keys();
            for (Object key : Collections.list(keys)) {
                if (!(key instanceof String) || !((String)key).endsWith(".font")) continue;
                Font font = (Font)UIManager.get(key);
                font = new FontUIResource(font.getName(), font.getStyle(), fontSize);
                defaults.put(key, font);
            }
        }
    }

    public static JabRefFrame getMainFrame() {
        return mainFrame;
    }

    public static void setMainFrame(JabRefFrame mainFrame) {
        JabRefGUI.mainFrame = mainFrame;
    }
}

