/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.tools;

import com.sun.javafx.webkit.Accessor;
import com.sun.webkit.WebPage;
import java.net.URL;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotParameters;
import javafx.scene.SnapshotResult;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Stage;
import javafx.util.Callback;

class SVGLoader {
    private SVGLoader() {
    }

    public static void loadSVGImage(URL svgImage, double prefWidth, double prefHeight, Callback<ImageView, Void> callback) {
        SVGLoader.loadSVGImage(svgImage, prefWidth, prefHeight, callback, null);
    }

    public static void loadSVGImage(URL svgImage, WritableImage outputImage) {
        if (outputImage == null) {
            throw new NullPointerException("outputImage can not be null");
        }
        double w = outputImage.getWidth();
        double h2 = outputImage.getHeight();
        SVGLoader.loadSVGImage(svgImage, w, h2, null, outputImage);
    }

    public static void loadSVGImage(URL svgImage, final double prefWidth, final double prefHeight, final Callback<ImageView, Void> callback, final WritableImage outputImage) {
        final WebView view = new WebView();
        final WebEngine eng = view.getEngine();
        WebPage webPage = Accessor.getPageFor((WebEngine)eng);
        webPage.setBackgroundColor(webPage.getMainFrame(), -256);
        webPage.setOpaque(webPage.getMainFrame(), false);
        Scene scene = new Scene((Parent)view);
        final Stage stage = new Stage();
        stage.setScene(scene);
        stage.setWidth(0.0);
        stage.setHeight(0.0);
        stage.setOpacity(0.0);
        stage.show();
        String content = "<html><body style=\"margin-top: 0px; margin-bottom: 30px; margin-left: 0px; margin-right: 0px; padding: 0;\"><img id=\"svgImage\" style=\"display: block;float: top;\" width=\"" + prefWidth + "\" height=\"" + prefHeight + "\" src=\"" + svgImage.toExternalForm() + "\" /></body></head>";
        eng.loadContent(content);
        eng.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> o, Worker.State oldValue, Worker.State newValue) {
                if (newValue == Worker.State.SUCCEEDED) {
                    double svgWidth = prefWidth >= 0.0 ? prefWidth : SVGLoader.getSvgWidth(eng);
                    double svgHeight = prefHeight >= 0.0 ? prefWidth : SVGLoader.getSvgHeight(eng);
                    SnapshotParameters params = new SnapshotParameters();
                    params.setFill((Paint)Color.TRANSPARENT);
                    params.setViewport(new Rectangle2D(0.0, 0.0, svgWidth, svgHeight));
                    view.snapshot((Callback)new Callback<SnapshotResult, Void>(){

                        public Void call(SnapshotResult param2) {
                            WritableImage snapshot = param2.getImage();
                            ImageView image = new ImageView((Image)snapshot);
                            if (callback != null) {
                                callback.call((Object)image);
                            }
                            stage.hide();
                            return null;
                        }
                    }, params, outputImage);
                }
            }
        });
    }

    private static double getSvgWidth(WebEngine webEngine) {
        Object result = SVGLoader.getSvgDomProperty(webEngine, "offsetWidth");
        if (result instanceof Integer) {
            return ((Integer)result).intValue();
        }
        return -1.0;
    }

    private static double getSvgHeight(WebEngine webEngine) {
        Object result = SVGLoader.getSvgDomProperty(webEngine, "offsetHeight");
        if (result instanceof Integer) {
            return ((Integer)result).intValue();
        }
        return -1.0;
    }

    private static Object getSvgDomProperty(WebEngine webEngine, String property) {
        return webEngine.executeScript("document.getElementById('svgImage')." + property);
    }
}

