/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.system;

import com.microsoft.applicationinsights.core.dependencies.apachecommons.lang3.SystemUtils;
import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Strings;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import java.lang.management.ManagementFactory;

public enum SystemInformation {
    INSTANCE;

    private static final String DEFAULT_PROCESS_NAME = "Java_Process";
    private String processId;

    public String getProcessId() {
        this.setProcessId();
        return this.processId;
    }

    public boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS;
    }

    public boolean isUnix() {
        return SystemUtils.IS_OS_UNIX;
    }

    private synchronized void setProcessId() {
        int i;
        if (!Strings.isNullOrEmpty(this.processId)) {
            return;
        }
        String rawName = ManagementFactory.getRuntimeMXBean().getName();
        if (!Strings.isNullOrEmpty(rawName) && (i = rawName.indexOf("@")) != -1) {
            String processIdAsString = rawName.substring(0, i);
            try {
                Integer.parseInt(processIdAsString);
                this.processId = processIdAsString;
                return;
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error("Failed to fetch process id: '%s'", e.toString());
            }
        }
        this.processId = DEFAULT_PROCESS_NAME;
    }
}

