/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.perfcounter;

import com.microsoft.applicationinsights.TelemetryClient;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;
import com.microsoft.applicationinsights.internal.perfcounter.AbstractPerformanceCounter;
import com.microsoft.applicationinsights.internal.system.SystemInformation;
import com.microsoft.applicationinsights.telemetry.PerformanceCounterTelemetry;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;

final class ProcessMemoryPerformanceCounter
extends AbstractPerformanceCounter {
    @Override
    public String getId() {
        return "JSDK_ProcessMemoryPerformanceCounter";
    }

    @Override
    public void report(TelemetryClient telemetryClient) {
        MemoryMXBean memoryData = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemoryUsage = memoryData.getHeapMemoryUsage();
        MemoryUsage nonHeapMemoryUsage = memoryData.getNonHeapMemoryUsage();
        double memoryBytes = heapMemoryUsage.getUsed();
        InternalLogger.INSTANCE.trace("Performance Counter: %s %s: %s", ProcessMemoryPerformanceCounter.getProcessCategoryName(), "Private Bytes", memoryBytes += (double)nonHeapMemoryUsage.getUsed());
        PerformanceCounterTelemetry telemetry = new PerformanceCounterTelemetry(ProcessMemoryPerformanceCounter.getProcessCategoryName(), "Private Bytes", SystemInformation.INSTANCE.getProcessId(), memoryBytes);
        telemetryClient.track(telemetry);
    }
}

