/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.applicationinsights.internal.channel.common;

import com.microsoft.applicationinsights.core.dependencies.googlecommon.base.Strings;
import com.microsoft.applicationinsights.internal.channel.common.BackOffTimesPolicy;
import com.microsoft.applicationinsights.internal.channel.common.ExponentialBackOffTimesPolicy;
import com.microsoft.applicationinsights.internal.channel.common.StaticBackOffTimesPolicy;
import com.microsoft.applicationinsights.internal.logger.InternalLogger;

final class BackOffTimesPolicyFactory {
    BackOffTimesPolicyFactory() {
    }

    public BackOffTimesPolicy create(String typeAsString) {
        BackOffPolicyType type = BackOffPolicyType.EXPONENTIAL;
        if (Strings.isNullOrEmpty(typeAsString)) {
            InternalLogger.INSTANCE.trace("No back-off container defined, using the default '%s'", new Object[]{type});
        } else {
            try {
                type = BackOffPolicyType.valueOf(typeAsString.toUpperCase());
            }
            catch (Exception e) {
                InternalLogger.INSTANCE.error("Failed to parse '%s', using the default back-off container '%s'", new Object[]{typeAsString, type});
            }
        }
        switch (type) {
            case STATIC: {
                return new StaticBackOffTimesPolicy();
            }
        }
        return new ExponentialBackOffTimesPolicy();
    }

    private static enum BackOffPolicyType {
        EXPONENTIAL,
        STATIC;

    }
}

