/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.system.procs;

import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.system.procs.BinaryDecoder;
import com.impossibl.postgres.system.procs.BinaryEncoder;
import com.impossibl.postgres.system.procs.SimpleProcProvider;
import com.impossibl.postgres.system.procs.Strings;
import com.impossibl.postgres.types.PrimitiveType;
import com.impossibl.postgres.types.Type;
import io.netty.buffer.ByteBuf;
import java.io.IOException;

public class Jsons
extends SimpleProcProvider {
    public Jsons() {
        super((Type.Codec.Encoder)Strings.TEXT_ENCODER, (Type.Codec.Decoder)Strings.TEXT_DECODER, (Type.Codec.Encoder)new BinEncoder(), (Type.Codec.Decoder)new BinDecoder(), "jsonb_");
    }

    public static class BinEncoder
    extends BinaryEncoder {
        @Override
        public Class<?> getInputType() {
            return String.class;
        }

        @Override
        public PrimitiveType getOutputPrimitiveType() {
            return PrimitiveType.String;
        }

        byte[] toBytes(Object val, Context context) {
            return val.toString().getBytes(context.getCharset());
        }

        @Override
        public void encode(Type type, ByteBuf buffer, Object val, Context context) throws IOException {
            if (val == null) {
                buffer.writeInt(-1);
            } else {
                byte[] bytes = this.toBytes(val, context);
                buffer.writeInt(bytes.length + 1);
                buffer.writeByte(1);
                buffer.writeBytes(bytes);
            }
        }
    }

    public static class BinDecoder
    extends BinaryDecoder {
        @Override
        public PrimitiveType getInputPrimitiveType() {
            return PrimitiveType.String;
        }

        @Override
        public Class<?> getOutputType() {
            return String.class;
        }

        @Override
        public String decode(Type type, Short typeLength, Integer typeModifier, ByteBuf buffer, Context context) throws IOException {
            int length = buffer.readInt();
            if (length == -1) {
                return null;
            }
            if (length < 1) {
                throw new IOException("Invalid length for jsonb");
            }
            byte version = buffer.readByte();
            if (version != 1) {
                throw new IOException("Invalid version for jsonb");
            }
            Integer maxLength = (Integer)context.getSetting("field.varying.length.max");
            byte[] bytes = maxLength != null ? new byte[Math.min(maxLength, length)] : new byte[--length];
            buffer.readBytes(bytes);
            buffer.skipBytes(length - bytes.length);
            return new String(bytes, context.getCharset());
        }
    }
}

