/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.v30;

import com.impossibl.postgres.protocol.Notice;
import com.impossibl.postgres.protocol.StartupCommand;
import com.impossibl.postgres.protocol.TransactionStatus;
import com.impossibl.postgres.protocol.v30.BaseProtocolListener;
import com.impossibl.postgres.protocol.v30.CommandImpl;
import com.impossibl.postgres.protocol.v30.ProtocolImpl;
import com.impossibl.postgres.system.BasicContext;
import com.impossibl.postgres.utils.MD5Authentication;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Map;

public class StartupCommandImpl
extends CommandImpl
implements StartupCommand {
    Map<String, Object> params;
    boolean ready;

    public StartupCommandImpl(Map<String, Object> params) {
        this.params = params;
    }

    @Override
    public void execute(final ProtocolImpl protocol) throws IOException {
        BaseProtocolListener listener = new BaseProtocolListener(){

            @Override
            public boolean isComplete() {
                return StartupCommandImpl.this.ready || StartupCommandImpl.this.error != null || StartupCommandImpl.this.exception != null;
            }

            @Override
            public synchronized void ready(TransactionStatus txStatus) {
                StartupCommandImpl.this.ready = true;
                this.notifyAll();
            }

            @Override
            public synchronized void error(Notice error) {
                StartupCommandImpl.this.setError(error);
                this.notifyAll();
            }

            @Override
            public synchronized void exception(Throwable cause) {
                StartupCommandImpl.this.setException(cause);
                this.notifyAll();
            }

            @Override
            public void notice(Notice notice) {
                StartupCommandImpl.this.addNotice(notice);
            }

            @Override
            public void backendKeyData(int processId, int secretKey) {
                protocol.getContext().setKeyData(processId, secretKey);
            }

            @Override
            public void authenticated(ProtocolImpl protocol2) {
            }

            @Override
            public void authenticateKerberos(ProtocolImpl protocol2) {
            }

            @Override
            public void authenticateClear(ProtocolImpl protocol2) throws IOException {
                BasicContext context = protocol2.getContext();
                String password = context.getSetting("password").toString();
                ByteBuf msg = protocol2.channel.alloc().buffer();
                protocol2.writePassword(msg, password);
                protocol2.send(msg);
            }

            @Override
            public void authenticateCrypt(ProtocolImpl protocol2) throws IOException {
            }

            @Override
            public void authenticateMD5(ProtocolImpl protocol2, byte[] salt) throws IOException {
                BasicContext context = protocol2.getContext();
                String username = context.getSetting("user").toString();
                String password = context.getSetting("password").toString();
                String response = MD5Authentication.encode(password, username, salt);
                ByteBuf msg = protocol2.channel.alloc().buffer();
                protocol2.writePassword(msg, response);
                protocol2.send(msg);
            }

            @Override
            public void authenticateSCM(ProtocolImpl protocol2) {
            }

            @Override
            public void authenticateGSS(ProtocolImpl protocol2) {
            }

            @Override
            public void authenticateGSSCont(ProtocolImpl protocol2) {
            }

            @Override
            public void authenticateSSPI(ProtocolImpl protocol2) {
            }
        };
        protocol.setListener(listener);
        ByteBuf msg = protocol.channel.alloc().buffer();
        protocol.writeStartup(msg, this.params);
        protocol.send(msg);
        this.waitFor(listener);
    }
}

