/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.languagetool.Language;
import org.languagetool.server.DatabaseLogEntry;
import org.languagetool.server.ServerTools;

class DatabaseCheckLogEntry
extends DatabaseLogEntry {
    private final Long userId;
    private final Long client;
    private final Long server;
    private final int textSize;
    private final int matches;
    private final Language lang;
    private final Language langDetected;
    private final int computationTime;
    private final Long textSessionId;
    private final Calendar date;
    private final String checkMode;

    public DatabaseCheckLogEntry(Long userId, Long client, Long server, int textSize, int matches, Language lang, Language langDetected, int computationTime, Long textSessionId, String checkMode) {
        this.userId = userId;
        this.client = client;
        this.server = server;
        this.textSize = textSize;
        this.matches = matches;
        this.lang = lang;
        this.langDetected = langDetected;
        this.computationTime = computationTime;
        this.textSessionId = textSessionId;
        this.checkMode = checkMode;
        this.date = Calendar.getInstance();
    }

    @Override
    public Map<Object, Object> getMapping() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        SimpleDateFormat dayFormat = new SimpleDateFormat("yyyy-MM-dd");
        dayFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        map.put("day", dayFormat.format(this.date.getTime()));
        map.put("date", ServerTools.getSQLDatetimeString(this.date));
        map.put("user_id", this.userId);
        map.put("textsize", this.textSize);
        map.put("matches", this.matches);
        map.put("language", StringUtils.abbreviate((String)this.lang.getShortCodeWithCountryAndVariant(), (int)30));
        map.put("language_detected", StringUtils.abbreviate((String)this.langDetected.getShortCodeWithCountryAndVariant(), (int)30));
        map.put("computation_time", this.computationTime);
        map.put("text_session_id", this.textSessionId);
        map.put("check_mode", StringUtils.abbreviate((String)this.checkMode, (int)32));
        map.put("server", this.server);
        map.put("client", this.client);
        return map;
    }

    @Override
    public String getMappingIdentifier() {
        return "org.languagetool.server.LogMapper.logCheck";
    }
}

