/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.internal.operations.BuildOperationConstraint;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

public abstract class ParallelResolveArtifactSet {
    private static final EmptySet EMPTY = new EmptySet();

    public abstract void visit(ArtifactVisitor var1);

    public static ParallelResolveArtifactSet wrap(ResolvedArtifactSet artifacts, BuildOperationExecutor buildOperationProcessor) {
        if (artifacts == ResolvedArtifactSet.EMPTY) {
            return EMPTY;
        }
        return new VisitingSet(artifacts, buildOperationProcessor);
    }

    private static class VisitingSet
    extends ParallelResolveArtifactSet {
        private final ResolvedArtifactSet artifacts;
        private final BuildOperationExecutor buildOperationProcessor;

        VisitingSet(ResolvedArtifactSet artifacts, BuildOperationExecutor buildOperationProcessor) {
            this.artifacts = artifacts;
            this.buildOperationProcessor = buildOperationProcessor;
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            StartVisitAction visitAction = new StartVisitAction(visitor);
            this.buildOperationProcessor.runAll((Action)visitAction, BuildOperationConstraint.UNCONSTRAINED);
            visitAction.visitResults();
        }

        private class StartVisitAction
        implements Action<BuildOperationQueue<RunnableBuildOperation>>,
        ResolvedArtifactSet.Visitor {
            private final ArtifactVisitor visitor;
            private final List<ResolvedArtifactSet.Artifacts> results = new ArrayList<ResolvedArtifactSet.Artifacts>();
            private BuildOperationQueue<RunnableBuildOperation> queue;

            StartVisitAction(ArtifactVisitor visitor) {
                this.visitor = visitor;
            }

            @Override
            public FileCollectionStructureVisitor.VisitType prepareForVisit(FileCollectionInternal.Source source) {
                return this.visitor.prepareForVisit(source);
            }

            @Override
            public void visitArtifacts(ResolvedArtifactSet.Artifacts artifacts) {
                artifacts.startFinalization(this.queue, this.visitor.requireArtifactFiles());
                this.results.add(artifacts);
            }

            public void execute(BuildOperationQueue<RunnableBuildOperation> buildOperationQueue) {
                this.queue = buildOperationQueue;
                VisitingSet.this.artifacts.visit(this);
            }

            public void visitResults() {
                for (ResolvedArtifactSet.Artifacts result : this.results) {
                    result.visit(this.visitor);
                }
            }
        }
    }

    private static class EmptySet
    extends ParallelResolveArtifactSet {
        private EmptySet() {
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
        }
    }
}

