/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.types;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.gradle.internal.classpath.types.InstrumentingTypeRegistry;

public class ExternalPluginsInstrumentingTypeRegistry
implements InstrumentingTypeRegistry {
    private final InstrumentingTypeRegistry gradleCoreInstrumentingTypeRegistry;
    private final Map<String, Set<String>> directSuperTypes;
    private final Map<String, Set<String>> superTypes = new ConcurrentHashMap<String, Set<String>>();

    public ExternalPluginsInstrumentingTypeRegistry(Map<String, Set<String>> directSuperTypes, InstrumentingTypeRegistry gradleCoreInstrumentingTypeRegistry) {
        this.directSuperTypes = ImmutableMap.copyOf(directSuperTypes);
        this.gradleCoreInstrumentingTypeRegistry = gradleCoreInstrumentingTypeRegistry;
    }

    @Override
    public Set<String> getSuperTypes(String type) {
        Set<String> superTypes = Collections.emptySet();
        if (type.startsWith("org/gradle")) {
            superTypes = this.gradleCoreInstrumentingTypeRegistry.getSuperTypes(type);
        }
        return !superTypes.isEmpty() ? superTypes : this.computeAndCacheSuperTypesForExternalType(type);
    }

    private Set<String> computeAndCacheSuperTypesForExternalType(String type) {
        return Collections.unmodifiableSet(this.superTypes.computeIfAbsent(type, this::computeSuperTypes));
    }

    private Set<String> computeSuperTypes(String type) {
        ArrayDeque<String> superTypes = new ArrayDeque<String>(this.getDirectSuperTypes(type));
        HashSet<String> collected = new HashSet<String>();
        collected.add(type);
        while (!superTypes.isEmpty()) {
            String superType = (String)superTypes.poll();
            if (!collected.add(superType)) continue;
            superTypes.addAll(this.getDirectSuperTypes(superType));
        }
        return collected;
    }

    private Set<String> getDirectSuperTypes(String type) {
        Set<String> superTypes = this.directSuperTypes.getOrDefault(type, Collections.emptySet());
        if (!superTypes.isEmpty() || !type.startsWith("org/gradle")) {
            return superTypes;
        }
        return this.gradleCoreInstrumentingTypeRegistry.getSuperTypes(type);
    }

    @Override
    public boolean isEmpty() {
        return this.directSuperTypes.isEmpty() && this.gradleCoreInstrumentingTypeRegistry.isEmpty();
    }
}

