/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.ivy.core.IvyPatternHelper;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.MetaDataParseException;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.PomDomParser;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.PomParent;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.RootPomParent;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.data.MavenDependencyKey;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.data.PomDependencyMgt;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.parser.data.PomProfile;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.local.LocallyAvailableExternalResource;
import org.gradle.internal.xml.XmlFactories;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PomReader
implements PomParent {
    private static final String PACKAGING = "packaging";
    private static final String DEPENDENCY = "dependency";
    private static final String DEPENDENCIES = "dependencies";
    private static final String DEPENDENCY_MGT = "dependencyManagement";
    private static final String PROJECT = "project";
    private static final String MODEL = "model";
    private static final String GROUP_ID = "groupId";
    private static final String ARTIFACT_ID = "artifactId";
    private static final String VERSION = "version";
    private static final String DESCRIPTION = "description";
    private static final String PARENT = "parent";
    private static final String SCOPE = "scope";
    private static final String CLASSIFIER = "classifier";
    private static final String OPTIONAL = "optional";
    private static final String EXCLUSIONS = "exclusions";
    private static final String EXCLUSION = "exclusion";
    private static final String DISTRIBUTION_MGT = "distributionManagement";
    private static final String RELOCATION = "relocation";
    private static final String PROPERTIES = "properties";
    private static final String TYPE = "type";
    private static final String PROFILES = "profiles";
    private static final String PROFILE = "profile";
    private static final String PROFILE_ID = "id";
    private static final String PROFILE_ACTIVATION = "activation";
    private static final String PROFILE_ACTIVATION_ACTIVE_BY_DEFAULT = "activeByDefault";
    private static final String PROFILE_ACTIVATION_PROPERTY = "property";
    private static final byte[] M2_ENTITIES_RESOURCE;
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY;
    private static final EntityResolver M2_ENTITY_RESOLVER;
    private PomParent pomParent = new RootPomParent();
    private final Map<String, String> pomProperties = new HashMap<String, String>();
    private final Map<String, String> effectiveProperties = new HashMap<String, String>();
    private List<PomDependencyMgt> declaredDependencyMgts;
    private List<PomProfile> declaredActivePomProfiles;
    private Map<MavenDependencyKey, PomDependencyMgt> resolvedDependencyMgts;
    private final Map<MavenDependencyKey, PomDependencyMgt> importedDependencyMgts = new LinkedHashMap<MavenDependencyKey, PomDependencyMgt>();
    private Map<MavenDependencyKey, PomDependencyData> resolvedDependencies;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final Element projectElement;
    private final Element parentElement;
    private static final Pattern VAR_PATTERN;

    public PomReader(LocallyAvailableExternalResource resource, ImmutableModuleIdentifierFactory moduleIdentifierFactory, Map<String, String> childPomProperties) throws SAXException {
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.setPomProperties(childPomProperties);
        String systemId = resource.getFile().toURI().toASCIIString();
        Document pomDomDoc = (Document)resource.withContent(inputStream -> {
            try {
                return PomReader.parseToDom(inputStream, systemId);
            }
            catch (Exception e) {
                throw new MetaDataParseException("POM", (ExternalResource)resource, e);
            }
        }).getResult();
        this.projectElement = pomDomDoc.getDocumentElement();
        if (!PROJECT.equals(this.projectElement.getNodeName()) && !MODEL.equals(this.projectElement.getNodeName())) {
            throw new SAXParseException("project must be the root tag", systemId, systemId, 0, 0);
        }
        this.parentElement = PomDomParser.getFirstChildElement(this.projectElement, PARENT);
        this.setDefaultParentGavProperties();
        this.setPomProperties(this.parseProperties(this.projectElement));
        this.setActiveProfileProperties();
    }

    public PomReader(LocallyAvailableExternalResource resource, ImmutableModuleIdentifierFactory moduleIdentifierFactory) throws SAXException {
        this(resource, moduleIdentifierFactory, Collections.emptyMap());
    }

    public void setPomParent(PomParent pomParent) {
        this.pomParent = pomParent;
        for (Map.Entry<String, String> entry : pomParent.getProperties().entrySet()) {
            this.maybeSetEffectiveProperty(entry.getKey(), entry.getValue());
        }
    }

    private void setDefaultParentGavProperties() {
        this.maybeSetGavProperties(GavProperty.PARENT_GROUP_ID, this.getParentGroupId());
        this.maybeSetGavProperties(GavProperty.PARENT_VERSION, this.getParentVersion());
        this.maybeSetGavProperties(GavProperty.PARENT_ARTIFACT_ID, this.getParentArtifactId());
    }

    private void maybeSetGavProperties(GavProperty gavProperty, String propertyValue) {
        for (String name : gavProperty.getNames()) {
            this.maybeSetEffectiveProperty(name, propertyValue);
        }
    }

    private void setPomProperties(Map<String, String> pomProperties) {
        if (!pomProperties.isEmpty()) {
            this.pomProperties.putAll(pomProperties);
            for (Map.Entry<String, String> pomProperty : pomProperties.entrySet()) {
                this.maybeSetEffectiveProperty(pomProperty.getKey(), pomProperty.getValue());
            }
        }
    }

    private void setActiveProfileProperties() {
        for (PomProfile activePomProfile : this.parseActivePomProfiles()) {
            for (Map.Entry<String, String> property : activePomProfile.getProperties().entrySet()) {
                this.effectiveProperties.put(property.getKey(), property.getValue());
            }
        }
    }

    private void maybeSetEffectiveProperty(String prop, String val) {
        if (!this.effectiveProperties.containsKey(prop) && val != null) {
            this.effectiveProperties.put(prop, val);
        }
    }

    public String toString() {
        return this.projectElement.getOwnerDocument().getDocumentURI();
    }

    private static DocumentBuilder getDocBuilder(EntityResolver entityResolver) {
        try {
            DocumentBuilder docBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            if (entityResolver != null) {
                docBuilder.setEntityResolver(entityResolver);
            }
            return docBuilder;
        }
        catch (ParserConfigurationException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document parseToDom(InputStream stream, String systemId) throws IOException, SAXException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ClassLoaderUtils.getPlatformClassLoader());
        try {
            PomDomParser.AddDTDFilterInputStream dtdStream = new PomDomParser.AddDTDFilterInputStream(stream);
            Document document = PomReader.getDocBuilder(M2_ENTITY_RESOLVER).parse(dtdStream, systemId);
            return document;
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public boolean hasParent() {
        return this.parentElement != null;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.effectiveProperties;
    }

    public void addImportedDependencyMgts(Map<MavenDependencyKey, PomDependencyMgt> inherited) {
        if (this.resolvedDependencyMgts != null) {
            throw new IllegalStateException("Cannot add imported dependency management elements after dependency management elements have been resolved for this POM.");
        }
        this.importedDependencyMgts.putAll(inherited);
    }

    private void checkNotNull(String value, String name) {
        this.checkNotNull(value, name, null);
    }

    private void checkNotNull(String value, String name, String element) {
        if (value == null) {
            String attributeName = element == null ? name : element + " " + name;
            throw new RuntimeException("Missing required attribute: " + attributeName);
        }
    }

    public String getGroupId() {
        String groupId = PomDomParser.getFirstChildText(this.projectElement, GROUP_ID);
        if (groupId == null) {
            groupId = PomDomParser.getFirstChildText(this.parentElement, GROUP_ID);
        }
        this.checkNotNull(groupId, GROUP_ID);
        return this.replaceProps(groupId);
    }

    public String getParentGroupId() {
        String groupId = PomDomParser.getFirstChildText(this.parentElement, GROUP_ID);
        if (groupId == null) {
            groupId = PomDomParser.getFirstChildText(this.projectElement, GROUP_ID);
        }
        this.checkNotNull(groupId, GROUP_ID);
        return this.replaceProps(groupId);
    }

    public String getArtifactId() {
        String val = PomDomParser.getFirstChildText(this.projectElement, ARTIFACT_ID);
        if (val == null) {
            val = PomDomParser.getFirstChildText(this.parentElement, ARTIFACT_ID);
        }
        this.checkNotNull(val, ARTIFACT_ID);
        return this.replaceProps(val);
    }

    public String getParentArtifactId() {
        String val = PomDomParser.getFirstChildText(this.parentElement, ARTIFACT_ID);
        if (val == null) {
            val = PomDomParser.getFirstChildText(this.projectElement, ARTIFACT_ID);
        }
        this.checkNotNull(val, ARTIFACT_ID);
        return this.replaceProps(val);
    }

    public String getVersion() {
        String val = PomDomParser.getFirstChildText(this.projectElement, VERSION);
        if (val == null) {
            val = PomDomParser.getFirstChildText(this.parentElement, VERSION);
        }
        return this.replaceProps(val);
    }

    public String getParentVersion() {
        String val = PomDomParser.getFirstChildText(this.parentElement, VERSION);
        if (val == null) {
            val = PomDomParser.getFirstChildText(this.projectElement, VERSION);
        }
        return this.replaceProps(val);
    }

    @Nonnull
    public String getPackaging() {
        String val = PomDomParser.getFirstChildText(this.projectElement, PACKAGING);
        if (val == null) {
            val = "jar";
        }
        return this.replaceProps(val);
    }

    public boolean hasGradleMetadataMarker() {
        NodeList childNodes = this.projectElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            String comment;
            Node node = childNodes.item(i);
            if (!(node instanceof Comment) || !(comment = node.getNodeValue()).contains("do_not_remove: published-with-gradle-metadata") && !comment.contains("do-not-remove: published-with-gradle-metadata")) continue;
            return true;
        }
        return false;
    }

    public ModuleVersionIdentifier getRelocation() {
        Element distrMgt = PomDomParser.getFirstChildElement(this.projectElement, DISTRIBUTION_MGT);
        Element relocation = PomDomParser.getFirstChildElement(distrMgt, RELOCATION);
        if (relocation == null) {
            return null;
        }
        String relocGroupId = PomDomParser.getFirstChildText(relocation, GROUP_ID);
        String relocArtId = PomDomParser.getFirstChildText(relocation, ARTIFACT_ID);
        String relocVersion = PomDomParser.getFirstChildText(relocation, VERSION);
        relocGroupId = relocGroupId == null ? this.getGroupId() : relocGroupId;
        relocArtId = relocArtId == null ? this.getArtifactId() : relocArtId;
        relocVersion = relocVersion == null ? this.getVersion() : relocVersion;
        return DefaultModuleVersionIdentifier.newId(relocGroupId, relocArtId, relocVersion);
    }

    @Override
    public Map<MavenDependencyKey, PomDependencyData> getDependencies() {
        if (this.resolvedDependencies == null) {
            this.resolvedDependencies = this.resolveDependencies();
        }
        return this.resolvedDependencies;
    }

    private Map<MavenDependencyKey, PomDependencyData> resolveDependencies() {
        LinkedHashMap<MavenDependencyKey, PomDependencyData> dependencies = new LinkedHashMap<MavenDependencyKey, PomDependencyData>();
        for (PomDependencyData pomDependencyData : this.getDependencyData(this.projectElement)) {
            dependencies.put(pomDependencyData.getId(), pomDependencyData);
        }
        for (Map.Entry entry : this.pomParent.getDependencies().entrySet()) {
            if (dependencies.containsKey(entry.getKey())) continue;
            dependencies.put((MavenDependencyKey)entry.getKey(), (PomDependencyData)entry.getValue());
        }
        for (PomProfile pomProfile : this.parseActivePomProfiles()) {
            for (PomDependencyData dependency : pomProfile.getDependencies()) {
                dependencies.put(dependency.getId(), dependency);
            }
        }
        return dependencies;
    }

    private List<PomDependencyData> getDependencyData(Element parentElement) {
        ArrayList<PomDependencyData> depElements = new ArrayList<PomDependencyData>();
        Element dependenciesElement = PomDomParser.getFirstChildElement(parentElement, DEPENDENCIES);
        if (dependenciesElement != null) {
            NodeList childs = dependenciesElement.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element) || !DEPENDENCY.equals(node.getNodeName())) continue;
                depElements.add(new PomDependencyData((Element)node));
            }
        }
        return depElements;
    }

    @Override
    public Map<MavenDependencyKey, PomDependencyMgt> getDependencyMgt() {
        if (this.resolvedDependencyMgts == null) {
            this.resolvedDependencyMgts = this.resolveDependencyMgt();
        }
        return this.resolvedDependencyMgts;
    }

    private Map<MavenDependencyKey, PomDependencyMgt> resolveDependencyMgt() {
        LinkedHashMap<MavenDependencyKey, PomDependencyMgt> dependencies = new LinkedHashMap<MavenDependencyKey, PomDependencyMgt>();
        dependencies.putAll(this.pomParent.getDependencyMgt());
        dependencies.putAll(this.importedDependencyMgts);
        for (PomDependencyMgt dependencyMgt : this.parseDependencyMgt()) {
            dependencies.put(dependencyMgt.getId(), dependencyMgt);
        }
        return dependencies;
    }

    public List<PomDependencyMgt> parseDependencyMgt() {
        if (this.declaredDependencyMgts == null) {
            List<PomDependencyMgt> dependencyMgts = this.getDependencyMgt(this.projectElement);
            for (PomProfile pomProfile : this.parseActivePomProfiles()) {
                dependencyMgts.addAll(pomProfile.getDependencyMgts());
            }
            this.declaredDependencyMgts = dependencyMgts;
        }
        return this.declaredDependencyMgts;
    }

    private List<PomDependencyMgt> getDependencyMgt(Element parentElement) {
        ArrayList<PomDependencyMgt> depMgmtElements = new ArrayList<PomDependencyMgt>();
        Element dependenciesElement = PomDomParser.getFirstChildElement(parentElement, DEPENDENCY_MGT);
        if ((dependenciesElement = PomDomParser.getFirstChildElement(dependenciesElement, DEPENDENCIES)) != null) {
            NodeList childs = dependenciesElement.getChildNodes();
            for (int i = 0; i < childs.getLength(); ++i) {
                Node node = childs.item(i);
                if (!(node instanceof Element) || !DEPENDENCY.equals(node.getNodeName())) continue;
                depMgmtElements.add(new PomDependencyMgtElement((Element)node));
            }
        }
        return depMgmtElements;
    }

    @Override
    public PomDependencyMgt findDependencyDefaults(MavenDependencyKey dependencyKey) {
        return this.getDependencyMgt().get(dependencyKey);
    }

    public void resolveGAV() {
        this.setGavPropertyValue(GavProperty.GROUP_ID, this.getGroupId());
        this.setGavPropertyValue(GavProperty.ARTIFACT_ID, this.getArtifactId());
        this.setGavPropertyValue(GavProperty.VERSION, this.getVersion());
    }

    private void setGavPropertyValue(GavProperty gavProperty, String propertyValue) {
        for (String name : gavProperty.getNames()) {
            this.effectiveProperties.put(name, propertyValue);
        }
    }

    private List<PomProfile> parseActivePomProfiles() {
        if (this.declaredActivePomProfiles == null) {
            ArrayList<PomProfile> activeByDefaultPomProfiles = new ArrayList<PomProfile>();
            ArrayList<PomProfile> activeByAbsenceOfPropertyPomProfiles = new ArrayList<PomProfile>();
            Element profilesElement = PomDomParser.getFirstChildElement(this.projectElement, PROFILES);
            if (profilesElement != null) {
                for (Element profileElement : PomDomParser.getAllChilds(profilesElement)) {
                    Element activationElement;
                    if (!PROFILE.equals(profileElement.getNodeName()) || (activationElement = PomDomParser.getFirstChildElement(profileElement, PROFILE_ACTIVATION)) == null) continue;
                    String activeByDefault = PomDomParser.getFirstChildText(activationElement, PROFILE_ACTIVATION_ACTIVE_BY_DEFAULT);
                    if ("true".equals(activeByDefault)) {
                        activeByDefaultPomProfiles.add(new PomProfileElement(profileElement));
                        continue;
                    }
                    Element propertyElement = PomDomParser.getFirstChildElement(activationElement, PROFILE_ACTIVATION_PROPERTY);
                    if (propertyElement == null || !this.isActivationPropertyActivated(propertyElement)) continue;
                    activeByAbsenceOfPropertyPomProfiles.add(new PomProfileElement(profileElement));
                }
            }
            this.declaredActivePomProfiles = this.determineActiveProfiles(activeByDefaultPomProfiles, activeByAbsenceOfPropertyPomProfiles);
        }
        return this.declaredActivePomProfiles;
    }

    private List<PomProfile> determineActiveProfiles(List<PomProfile> activeByDefaultPomProfiles, List<PomProfile> activeByAbsenceOfPropertyPomProfiles) {
        return !activeByAbsenceOfPropertyPomProfiles.isEmpty() ? activeByAbsenceOfPropertyPomProfiles : activeByDefaultPomProfiles;
    }

    private boolean isActivationPropertyActivated(Element propertyElement) {
        String propertyName = PomDomParser.getFirstChildText(propertyElement, "name");
        return propertyName.startsWith("!");
    }

    Map<String, String> getAllPomProperties() {
        return this.pomProperties;
    }

    private Map<String, String> parseProperties(Element parentElement) {
        HashMap<String, String> pomProperties = new HashMap<String, String>();
        Element propsEl = PomDomParser.getFirstChildElement(parentElement, PROPERTIES);
        if (propsEl != null) {
            propsEl.normalize();
        }
        for (Element prop : PomDomParser.getAllChilds(propsEl)) {
            pomProperties.put(prop.getNodeName(), PomDomParser.getTextContent(prop));
        }
        return pomProperties;
    }

    private String replaceProps(String val) {
        if (val == null) {
            return null;
        }
        return IvyPatternHelper.substituteVariables((String)val, this.effectiveProperties).trim();
    }

    public static boolean hasUnresolvedSubstitutions(String value) {
        return value.contains("$") && VAR_PATTERN.matcher(value).matches();
    }

    static {
        byte[] bytes;
        try {
            bytes = IOUtils.toByteArray((InputStream)org.apache.ivy.plugins.parser.m2.PomReader.class.getResourceAsStream("m2-entities.ent"));
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        M2_ENTITIES_RESOURCE = bytes;
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(ClassLoaderUtils.getPlatformClassLoader());
        try {
            DOCUMENT_BUILDER_FACTORY = XmlFactories.newDocumentBuilderFactory();
            DOCUMENT_BUILDER_FACTORY.setValidating(false);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
        M2_ENTITY_RESOLVER = new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) {
                if (systemId != null && systemId.endsWith("m2-entities.ent")) {
                    return new InputSource(new ByteArrayInputStream(M2_ENTITIES_RESOURCE));
                }
                return null;
            }
        };
        VAR_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");
    }

    public class PomProfileElement
    implements PomProfile {
        private final Element element;
        private List<PomDependencyMgt> declaredDependencyMgts;
        private List<PomDependencyData> declaredDependencies;

        PomProfileElement(Element element) {
            this.element = element;
        }

        @Override
        public String getId() {
            return PomDomParser.getFirstChildText(this.element, PomReader.PROFILE_ID);
        }

        @Override
        public Map<String, String> getProperties() {
            return PomReader.this.parseProperties(this.element);
        }

        @Override
        public List<PomDependencyMgt> getDependencyMgts() {
            if (this.declaredDependencyMgts == null) {
                this.declaredDependencyMgts = PomReader.this.getDependencyMgt(this.element);
            }
            return this.declaredDependencyMgts;
        }

        @Override
        public List<PomDependencyData> getDependencies() {
            if (this.declaredDependencies == null) {
                this.declaredDependencies = PomReader.this.getDependencyData(this.element);
            }
            return this.declaredDependencies;
        }
    }

    public class PomDependencyData
    extends PomDependencyMgtElement {
        private final Element depElement;

        PomDependencyData(Element depElement) {
            super(depElement);
            this.depElement = depElement;
        }

        public boolean isOptional() {
            Element e = PomDomParser.getFirstChildElement(this.depElement, PomReader.OPTIONAL);
            return e != null && "true".equalsIgnoreCase(PomDomParser.getTextContent(e));
        }
    }

    public class PomDependencyMgtElement
    implements PomDependencyMgt {
        private final Element depElement;

        PomDependencyMgtElement(Element depElement) {
            this.depElement = depElement;
        }

        @Override
        public MavenDependencyKey getId() {
            return new MavenDependencyKey(this.getGroupId(), this.getArtifactId(), this.getType(), this.getClassifier());
        }

        @Override
        public String getGroupId() {
            String val = PomDomParser.getFirstChildText(this.depElement, PomReader.GROUP_ID);
            PomReader.this.checkNotNull(val, PomReader.GROUP_ID, PomReader.DEPENDENCY);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getArtifactId() {
            String val = PomDomParser.getFirstChildText(this.depElement, PomReader.ARTIFACT_ID);
            PomReader.this.checkNotNull(val, PomReader.ARTIFACT_ID, PomReader.DEPENDENCY);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getVersion() {
            String val = PomDomParser.getFirstChildText(this.depElement, PomReader.VERSION);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getScope() {
            String val = PomDomParser.getFirstChildText(this.depElement, PomReader.SCOPE);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public String getType() {
            String val = PomDomParser.getFirstChildText(this.depElement, PomReader.TYPE);
            if ((val = PomReader.this.replaceProps(val)) == null) {
                val = "jar";
            }
            return val;
        }

        @Override
        public String getClassifier() {
            String val = PomDomParser.getFirstChildText(this.depElement, PomReader.CLASSIFIER);
            return PomReader.this.replaceProps(val);
        }

        @Override
        public List<ModuleIdentifier> getExcludedModules() {
            Element exclusionsElement = PomDomParser.getFirstChildElement(this.depElement, PomReader.EXCLUSIONS);
            if (exclusionsElement != null) {
                NodeList childs = exclusionsElement.getChildNodes();
                ArrayList exclusions = Lists.newArrayList();
                for (int i = 0; i < childs.getLength(); ++i) {
                    Node node = childs.item(i);
                    if (!(node instanceof Element) || !PomReader.EXCLUSION.equals(node.getNodeName())) continue;
                    String groupId = PomDomParser.getFirstChildText((Element)node, PomReader.GROUP_ID);
                    String artifactId = PomDomParser.getFirstChildText((Element)node, PomReader.ARTIFACT_ID);
                    if (groupId == null && artifactId == null) continue;
                    String resolvedGroupId = groupId != null ? PomReader.this.replaceProps(groupId) : "*";
                    String resolvedArtifactId = artifactId != null ? PomReader.this.replaceProps(artifactId) : "*";
                    exclusions.add(PomReader.this.moduleIdentifierFactory.module(resolvedGroupId, resolvedArtifactId));
                }
                return exclusions;
            }
            return Collections.emptyList();
        }
    }

    private static enum GavProperty {
        PARENT_GROUP_ID("parent.groupId", "project.parent.groupId"),
        PARENT_ARTIFACT_ID("parent.artifactId", "project.parent.artifactId"),
        PARENT_VERSION("parent.version", "project.parent.version"),
        GROUP_ID("project.groupId", "pom.groupId", "groupId"),
        ARTIFACT_ID("project.artifactId", "pom.artifactId", "artifactId"),
        VERSION("project.version", "pom.version", "version");

        private final String[] names;

        private GavProperty(String ... names) {
            this.names = names;
        }

        public String[] getNames() {
            return this.names;
        }
    }
}

