/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect.validation;

import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.api.problems.BuildableProblemBuilder;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.ProblemBuilder;
import org.gradle.api.problems.ProblemBuilderDefiningCategory;
import org.gradle.api.problems.ProblemBuilderDefiningDocumentation;
import org.gradle.api.problems.ProblemBuilderDefiningLabel;
import org.gradle.api.problems.ProblemBuilderDefiningLocation;
import org.gradle.api.problems.ReportableProblem;
import org.gradle.api.problems.Severity;

@NonNullApi
class DelegatingProblemBuilder
implements ProblemBuilderDefiningLabel,
ProblemBuilderDefiningDocumentation,
ProblemBuilderDefiningLocation,
ProblemBuilderDefiningCategory,
BuildableProblemBuilder {
    private final Object delegate;

    DelegatingProblemBuilder(ProblemBuilderDefiningLabel delegate) {
        this.delegate = delegate;
    }

    public ProblemBuilderDefiningDocumentation label(String label, Object ... args) {
        ProblemBuilderDefiningDocumentation newDelegate = ((ProblemBuilderDefiningLabel)this.delegate).label(label, args);
        return this.validateDelegate(newDelegate);
    }

    public ProblemBuilderDefiningLocation documentedAt(DocLink doc) {
        ProblemBuilderDefiningLocation newDelegate = ((ProblemBuilderDefiningDocumentation)this.delegate).documentedAt(doc);
        return this.validateDelegate(newDelegate);
    }

    public ProblemBuilderDefiningLocation undocumented() {
        ProblemBuilderDefiningLocation newDelegate = ((ProblemBuilderDefiningDocumentation)this.delegate).undocumented();
        return this.validateDelegate(newDelegate);
    }

    public ProblemBuilderDefiningCategory fileLocation(String path, @Nullable Integer line, @Nullable Integer column, @Nullable Integer length) {
        ProblemBuilderDefiningCategory newDelegate = ((ProblemBuilderDefiningLocation)this.delegate).fileLocation(path, line, column, length);
        return this.validateDelegate(newDelegate);
    }

    public ProblemBuilderDefiningCategory pluginLocation(String pluginId) {
        ProblemBuilderDefiningCategory newDelegate = ((ProblemBuilderDefiningLocation)this.delegate).pluginLocation(pluginId);
        return this.validateDelegate(newDelegate);
    }

    private <T> T validateDelegate(T newDelegate) {
        if (this.delegate != newDelegate) {
            throw new IllegalStateException("Builder pattern expected to return 'this'");
        }
        return newDelegate;
    }

    public ProblemBuilderDefiningCategory stackLocation() {
        ProblemBuilderDefiningCategory newDelegate = ((ProblemBuilderDefiningLocation)this.delegate).stackLocation();
        return this.validateDelegate(newDelegate);
    }

    public ProblemBuilderDefiningCategory noLocation() {
        ProblemBuilderDefiningCategory newDelegate = ((ProblemBuilderDefiningLocation)this.delegate).noLocation();
        return this.validateDelegate(newDelegate);
    }

    public ProblemBuilder category(String category, String ... details) {
        ProblemBuilder newDelegate = ((ProblemBuilderDefiningCategory)this.delegate).category(category, details);
        return this.validateDelegate(newDelegate);
    }

    public BuildableProblemBuilder details(String details) {
        ProblemBuilder newDelegate = ((BuildableProblemBuilder)this.delegate).details(details);
        return (BuildableProblemBuilder)this.validateDelegate(newDelegate);
    }

    public BuildableProblemBuilder solution(@Nullable String solution) {
        ProblemBuilder newDelegate = ((BuildableProblemBuilder)this.delegate).solution(solution);
        return (BuildableProblemBuilder)this.validateDelegate(newDelegate);
    }

    public BuildableProblemBuilder additionalData(String key, String value) {
        ProblemBuilder newDelegate = ((BuildableProblemBuilder)this.delegate).additionalData(key, value);
        return (BuildableProblemBuilder)this.validateDelegate(newDelegate);
    }

    public BuildableProblemBuilder withException(RuntimeException e) {
        ProblemBuilder newDelegate = ((BuildableProblemBuilder)this.delegate).withException(e);
        return (BuildableProblemBuilder)this.validateDelegate(newDelegate);
    }

    public BuildableProblemBuilder severity(@Nullable Severity severity) {
        ProblemBuilder newDelegate = ((BuildableProblemBuilder)this.delegate).severity(severity);
        return (BuildableProblemBuilder)this.validateDelegate(newDelegate);
    }

    public ReportableProblem build() {
        return ((BuildableProblemBuilder)this.delegate).build();
    }
}

