/*
 * Decompiled with CFR 0.152.
 */
package mill.api;

import fansi.Attrs;
import fansi.Attrs$;
import java.io.InputStream;
import java.io.PrintStream;
import mill.api.SystemStreams;
import mill.moduledefs.Scaladoc;
import os.Path;
import scala.Function0;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;

@Scaladoc(value="/**\n * The standard logging interface of the Mill build tool.\n *\n * Contains these primary logging methods, in order of increasing importance:\n *\n * - `debug` : internal debug messages normally not shown to the user;\n * mostly useful when debugging issues\n *\n * - `ticker`: short-lived logging output where consecutive lines over-write\n * each other; useful for information which is transient and disposable\n *\n * - `info`: miscellaneous logging output which isn't part of the main output\n * a user is looking for, but useful to provide context on what Mill is doing\n *\n * - `error`: logging output which represents problems the user should care\n * about\n *\n * Also contains the two forwarded stdout and stderr streams, for code executed\n * by Mill to use directly. Typically, these correspond to the stdout and stderr,\n * but when `show` is used both are forwarded to stderr and stdout is only\n * used to display the final `show` output for easy piping.\n */")
@ScalaSignature(bytes="\u0006\u0005\u0005efa\u0002\u0011\"!\u0003\r\tA\n\u0005\u0006e\u0001!\ta\r\u0005\u0006u\u0001!\ta\u000f\u0005\u0006\u0005\u0002!\ta\u000f\u0005\u0006\u0007\u00021\t\u0001\u0012\u0005\u0007\u0011\u0002!\taI%\t\u000b9\u0003a\u0011A%\t\u000b=\u0003A\u0011\u0001)\t\u000b]\u0003A\u0011\u0001)\t\u000ba\u0003A\u0011\u0001)\t\u000b\r\u0004A\u0011\u00013\t\u000b!\u0004a\u0011A5\t\u000b]\u0004a\u0011\u0001=\t\u000bi\u0004a\u0011A>\t\u000bu\u0004a\u0011\u0001@\t\u0011\u0005\u0005\u0001\u0001\"\u0001$\u0003\u0007A\u0001\"!\b\u0001\t\u0003\u0019\u0013q\u0004\u0005\t\u0003G\u0001A\u0011A\u0012\u0002&!9\u00111\u0005\u0001\u0005\u0002\r\u001a\u0004\u0002CA\u0019\u0001\u0011\u00051%a\r\t\u000f\u0005]\u0002\u0001\"\u0001$g!A\u0011\u0011\b\u0001\u0005\u0002\r\nY\u0004C\u0004\u0002:\u0001!\taI\u001a\t\u0011\u0005}\u0002\u0001\"\u0001$\u0003\u0003B\u0001\"!\u001a\u0001\t\u0003\u0019\u0013q\r\u0005\u0007\u0003g\u0002A\u0011\u0001#\t\r\u0005m\u0004\u0001\"\u00014\u0011\u0019\ti\b\u0001C\u0001\t\"A\u0011q\u0010\u0001\u0005\u0002\r\n\t\t\u0003\u0005\u0002\u001a\u0002!\taIAN\u0011\u001d\t9\u000b\u0001C\u0001\u0003SC\u0001\"a,\u0001\t\u0003\u0019\u0013\u0011\u0017\u0002\u0007\u0019><w-\u001a:\u000b\u0005\t\u001a\u0013aA1qS*\tA%\u0001\u0003nS2d7\u0001A\n\u0004\u0001\u001dz\u0003C\u0001\u0015.\u001b\u0005I#B\u0001\u0016,\u0003\u0011a\u0017M\\4\u000b\u00031\nAA[1wC&\u0011a&\u000b\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005!\u0002\u0014BA\u0019*\u00055\tU\u000f^8DY>\u001cX-\u00192mK\u00061A%\u001b8ji\u0012\"\u0012\u0001\u000e\t\u0003kaj\u0011A\u000e\u0006\u0002o\u0005)1oY1mC&\u0011\u0011H\u000e\u0002\u0005+:LG/A\u0005j]\u001a|7i\u001c7peV\tA\b\u0005\u0002>\u00016\taHC\u0001@\u0003\u00151\u0017M\\:j\u0013\t\teHA\u0003BiR\u00148/\u0001\u0006feJ|'oQ8m_J\fqaY8m_J,G-F\u0001F!\t)d)\u0003\u0002Hm\t9!i\\8mK\u0006t\u0017aF;oaJ,g-\u001b=fINK8\u000f^3n'R\u0014X-Y7t+\u0005Q\u0005CA&M\u001b\u0005\t\u0013BA'\"\u00055\u0019\u0016p\u001d;f[N#(/Z1ng\u0006i1/_:uK6\u001cFO]3b[N\f1\"\u001a:s_J\u001cFO]3b[V\t\u0011\u000b\u0005\u0002S+6\t1K\u0003\u0002UW\u0005\u0011\u0011n\\\u0005\u0003-N\u00131\u0002\u0015:j]R\u001cFO]3b[\u0006aq.\u001e;qkR\u001cFO]3b[\u0006y!/Y<PkR\u0004X\u000f^*ue\u0016\fW\u000e\u000b\u0003\n5\u0002\f\u0007CA._\u001b\u0005a&BA/$\u0003)iw\u000eZ;mK\u0012,gm]\u0005\u0003?r\u0013\u0001bU2bY\u0006$wnY\u0001\u0006m\u0006dW/Z\u0011\u0002E\u0006\u00119c\f\u0016+\u0015\u0001\u0002\u0003E\u000b\u0011\\7J\fwoT;uaV$8\u000b\u001e:fC6lV\fI5tA%tG/\u001a8eK\u0012\u0004Co\u001c\u0011cK\u0002\n\u0007E^3sg&|g\u000eI8gAm[v.\u001e;qkR\u001cFO]3b[vk&\u0002\t\u0011!U\u0001:\u0018\u000e\u001e5pkR\u0004C-Z2pe\u0006$\u0018n\u001c8;A\r|Gn\u001c:tY\u0001\u0002(/\u001a4jq\u0016\u001cH\u0006\t;j[\u0016\u001cH/Y7qg2\u0002S\r^2/A%#\b%[:!S:$XM\u001c3fI*\u0001\u0003\u0005\t\u0016!M>\u0014\b\u0005\u001e5fAU\u001cX\rI8gAQ\f7o[:!Y&\\W\r\t1tQ><\b\rI<iS\u000eD\u0007e\\;uaV$\b\u0005Z1uC\u0002Jg\u000eI1!o\u0006L\b\u0005\u001e5bi\u0002J7O\u0003\u0011!A)\u0002S-Y:jYf\u0004#/Z1eC\ndW\r\t2zA\u0011|wO\\:ue\u0016\fW\u000e\t9s_\u001e\u0014\u0018-\\:/\u0015\u0001\u0002\u0003EK\u0018\u0002\u0011%t7\u000b\u001e:fC6,\u0012!\u001a\t\u0003%\u001aL!aZ*\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\\\u0001\u0005S:4w\u000e\u0006\u00025U\")1n\u0003a\u0001Y\u0006\t1\u000f\u0005\u0002ni:\u0011aN\u001d\t\u0003_Zj\u0011\u0001\u001d\u0006\u0003c\u0016\na\u0001\u0010:p_Rt\u0014BA:7\u0003\u0019\u0001&/\u001a3fM&\u0011QO\u001e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005M4\u0014!\u00023fEV<GC\u0001\u001bz\u0011\u0015YG\u00021\u0001m\u0003\u0015)'O]8s)\t!D\u0010C\u0003l\u001b\u0001\u0007A.\u0001\u0004uS\u000e\\WM\u001d\u000b\u0003i}DQa\u001b\bA\u00021\fqb]3u!J|W\u000e\u001d;EKR\f\u0017\u000e\u001c\u000b\u0006i\u0005\u0015\u00111\u0004\u0005\b\u0003\u000fy\u0001\u0019AA\u0005\u0003\rYW-\u001f\t\u0006\u0003\u0017\t)\u0002\u001c\b\u0005\u0003\u001b\t\tBD\u0002p\u0003\u001fI\u0011aN\u0005\u0004\u0003'1\u0014a\u00029bG.\fw-Z\u0005\u0005\u0003/\tIBA\u0002TKFT1!a\u00057\u0011\u0015Yw\u00021\u0001m\u0003%\u0011X\r]8si.+\u0017\u0010F\u00025\u0003CAq!a\u0002\u0011\u0001\u0004\tI!A\u0007tKR\u0004&o\\7qi2Kg.\u001a\u000b\bi\u0005\u001d\u0012\u0011FA\u0017\u0011\u001d\t9!\u0005a\u0001\u0003\u0013Aa!a\u000b\u0012\u0001\u0004a\u0017\u0001\u0005<fe\n|7/Z&fsN+hMZ5y\u0011\u0019\ty#\u0005a\u0001Y\u00069Q.Z:tC\u001e,\u0017!F:fiB\u0013x.\u001c9u\u0011\u0016\fG-\u001a:Qe\u00164\u0017\u000e\u001f\u000b\u0004i\u0005U\u0002\"B6\u0014\u0001\u0004a\u0017aE2mK\u0006\u0014\bK]8naR\u001cF/\u0019;vg\u0016\u001c\u0018\u0001\u0005:f[>4X\r\u0015:p[B$H*\u001b8f)\r!\u0014Q\b\u0005\b\u0003\u000f)\u0002\u0019AA\u0005\u0003A9\u0018\u000e\u001e5Qe>l\u0007\u000f\u001e)bkN,G-\u0006\u0003\u0002D\u0005%C\u0003BA#\u00037\u0002B!a\u0012\u0002J1\u0001AaBA&/\t\u0007\u0011Q\n\u0002\u0002)F!\u0011qJA+!\r)\u0014\u0011K\u0005\u0004\u0003'2$a\u0002(pi\"Lgn\u001a\t\u0004k\u0005]\u0013bAA-m\t\u0019\u0011I\\=\t\u0011\u0005us\u0003\"a\u0001\u0003?\n\u0011\u0001\u001e\t\u0006k\u0005\u0005\u0014QI\u0005\u0004\u0003G2$\u0001\u0003\u001fcs:\fW.\u001a \u0002%]LG\u000f\u001b)s_6\u0004H/\u00168qCV\u001cX\rZ\u000b\u0005\u0003S\ni\u0007\u0006\u0003\u0002l\u0005=\u0004\u0003BA$\u0003[\"q!a\u0013\u0019\u0005\u0004\ti\u0005\u0003\u0005\u0002^a!\t\u0019AA9!\u0015)\u0014\u0011MA6\u00031!WMY;h\u000b:\f'\r\\3eQ\u0015I\"\fYA<C\t\tI(A\u00110U)R\u0001\u0005\t\u0011+A\u0001\u001b\u0018N\\2fA5KG\u000e\u001c\u00111]E\u0002d&\u000e\u0006!A\u0001Rs&A\u0003dY>\u001cX-\u0001\u0007f]\u0006\u0014G.\u001a+jG.,'/A\u0005tk\ndunZ4feRA\u00111QAC\u0003+\u000b9\n\u0005\u0002L\u0001!9\u0011q\u0011\u000fA\u0002\u0005%\u0015\u0001\u00029bi\"\u0004B!a#\u0002\u00126\u0011\u0011Q\u0012\u0006\u0003\u0003\u001f\u000b!a\\:\n\t\u0005M\u0015Q\u0012\u0002\u0005!\u0006$\b\u000e\u0003\u0004\u0002,q\u0001\r\u0001\u001c\u0005\u0007\u0003_a\u0002\u0019\u00017\u0002\u0015]LG\u000f\u001b)s_6\u0004H/\u0006\u0003\u0002\u001e\u0006\u0005F\u0003BAP\u0003G\u0003B!a\u0012\u0002\"\u00129\u00111J\u000fC\u0002\u00055\u0003\u0002CA/;\u0011\u0005\r!!*\u0011\u000bU\n\t'a(\u0002\u001b]LG\u000f[(viN#(/Z1n)\u0011\t\u0019)a+\t\r\u00055f\u00041\u0001R\u0003%yW\u000f^*ue\u0016\fW.\u0001\u0007m_\u001e\u0004&/\u001a4jq.+\u00170\u0006\u0002\u0002\n!*\u0001A\u00171\u00026\u0006\u0012\u0011qW\u0001\b~=R#F\u0003\u0011+AQCW\rI:uC:$\u0017M\u001d3!Y><w-\u001b8hA%tG/\u001a:gC\u000e,\u0007e\u001c4!i\",\u0007%T5mY\u0002\u0012W/\u001b7eAQ|w\u000e\u001c\u0018\u000bA)R\u0001E\u000b\u0011D_:$\u0018-\u001b8tAQDWm]3!aJLW.\u0019:zA1|wmZ5oO\u0002jW\r\u001e5pINd\u0003%\u001b8!_J$WM\u001d\u0011pM\u0002Jgn\u0019:fCNLgn\u001a\u0011j[B|'\u000f^1oG\u0016T$\u0002\t\u0016\u000bA)\u0002S\u0006\t1eK\n,x\r\u0019\u0011;A%tG/\u001a:oC2\u0004C-\u001a2vO\u0002jWm]:bO\u0016\u001c\bE\\8s[\u0006dG.\u001f\u0011o_R\u00043\u000f[8x]\u0002\"x\u000e\t;iK\u0002*8/\u001a:<\u0015\u0001R\u0003%\\8ti2L\b%^:fMVd\u0007e\u001e5f]\u0002\"WMY;hO&tw\rI5tgV,7O\u0003\u0011+\u0015\u0001R\u0003%\f\u0011ai&\u001c7.\u001a:au\u0001\u001a\bn\u001c:u[1Lg/\u001a3!Y><w-\u001b8hA=,H\u000f];uA]DWM]3!G>t7/Z2vi&4X\r\t7j]\u0016\u001c\be\u001c<fe6:(/\u001b;f\u0015\u0001R\u0003%Z1dQ\u0002zG\u000f[3sw\u0001*8/\u001a4vY\u00022wN\u001d\u0011j]\u001a|'/\\1uS>t\u0007e\u001e5jG\"\u0004\u0013n\u001d\u0011ue\u0006t7/[3oi\u0002\ng\u000e\u001a\u0011eSN\u0004xn]1cY\u0016T\u0001E\u000b\u0006!U\u0001j\u0003\u0005Y5oM>\u0004'\bI7jg\u000e,G\u000e\\1oK>,8\u000f\t7pO\u001eLgn\u001a\u0011pkR\u0004X\u000f\u001e\u0011xQ&\u001c\u0007\u000eI5t]\u001e\"\b\u0005]1si\u0002zg\r\t;iK\u0002j\u0017-\u001b8!_V$\b/\u001e;\u000bA)\u0002\u0013\rI;tKJ\u0004\u0013n\u001d\u0011m_>\\\u0017N\\4!M>\u0014H\u0006\t2vi\u0002*8/\u001a4vY\u0002\"x\u000e\t9s_ZLG-\u001a\u0011d_:$X\r\u001f;!_:\u0004s\u000f[1uA5KG\u000e\u001c\u0011jg\u0002\"w.\u001b8h\u0015\u0001R#\u0002\t\u0016![\u0001\u0002WM\u001d:pe\u0002T\u0004\u0005\\8hO&tw\rI8viB,H\u000fI<iS\u000eD\u0007E]3qe\u0016\u001cXM\u001c;tAA\u0014xN\u00197f[N\u0004C\u000f[3!kN,'\u000fI:i_VdG\rI2be\u0016T\u0001E\u000b\u0011bE>,HO\u0003\u0011+\u0015\u0001R\u0003%\u00117t_\u0002\u001awN\u001c;bS:\u001c\b\u0005\u001e5fAQ<x\u000e\t4pe^\f'\u000fZ3eAM$Hm\\;uA\u0005tG\rI:uI\u0016\u0014(\u000fI:ue\u0016\fWn\u001d\u0017!M>\u0014\beY8eK\u0002*\u00070Z2vi\u0016$'\u0002\t\u0016!Ef\u0004S*\u001b7mAQ|\u0007%^:fA\u0011L'/Z2uYft\u0003\u0005V=qS\u000e\fG\u000e\\=-AQDWm]3!G>\u0014(/Z:q_:$\u0007\u0005^8!i\",\u0007e\u001d;e_V$\b%\u00198eAM$H-\u001a:sY)\u0001#\u0006\t2vi\u0002:\b.\u001a8!ANDwn\u001e1!SN\u0004So]3eA\t|G\u000f\u001b\u0011be\u0016\u0004cm\u001c:xCJ$W\r\u001a\u0011u_\u0002\u001aH\u000fZ3se\u0002\ng\u000e\u001a\u0011ti\u0012|W\u000f\u001e\u0011jg\u0002zg\u000e\\=\u000bA)\u0002So]3eAQ|\u0007\u0005Z5ta2\f\u0017\u0010\t;iK\u00022\u0017N\\1mA\u0001\u001c\bn\\<aA=,H\u000f];uA\u0019|'\u000fI3bgf\u0004\u0003/\u001b9j]\u001et#\u0002\t\u00160\u0001")
public interface Logger
extends AutoCloseable {
    public static /* synthetic */ Attrs infoColor$(Logger $this) {
        return $this.infoColor();
    }

    default public Attrs infoColor() {
        return Attrs$.MODULE$.Empty();
    }

    public static /* synthetic */ Attrs errorColor$(Logger $this) {
        return $this.errorColor();
    }

    default public Attrs errorColor() {
        return Attrs$.MODULE$.Empty();
    }

    public boolean colored();

    public static /* synthetic */ SystemStreams unprefixedSystemStreams$(Logger $this) {
        return $this.unprefixedSystemStreams();
    }

    default public SystemStreams unprefixedSystemStreams() {
        return this.systemStreams();
    }

    public SystemStreams systemStreams();

    public static /* synthetic */ PrintStream errorStream$(Logger $this) {
        return $this.errorStream();
    }

    default public PrintStream errorStream() {
        return this.systemStreams().err();
    }

    public static /* synthetic */ PrintStream outputStream$(Logger $this) {
        return $this.outputStream();
    }

    default public PrintStream outputStream() {
        return this.systemStreams().out();
    }

    public static /* synthetic */ PrintStream rawOutputStream$(Logger $this) {
        return $this.rawOutputStream();
    }

    @Scaladoc(value="/**\n   * [[rawOutputStream]] is intended to be a version of [[outputStream]]\n   * without decoration: colors, prefixes, timestamps, etc. It is intended\n   * for the use of tasks like `show` which output data in a way that is\n   * easily readable by downstream programs.\n   */")
    default public PrintStream rawOutputStream() {
        return this.systemStreams().out();
    }

    public static /* synthetic */ InputStream inStream$(Logger $this) {
        return $this.inStream();
    }

    default public InputStream inStream() {
        return this.systemStreams().in();
    }

    public void info(String var1);

    public void debug(String var1);

    public void error(String var1);

    public void ticker(String var1);

    public static /* synthetic */ void setPromptDetail$(Logger $this, Seq key2, String s) {
        $this.setPromptDetail(key2, s);
    }

    default public void setPromptDetail(Seq<String> key2, String s) {
        this.ticker(s);
    }

    public static /* synthetic */ void reportKey$(Logger $this, Seq key2) {
        $this.reportKey(key2);
    }

    default public void reportKey(Seq<String> key2) {
    }

    public static /* synthetic */ void setPromptLine$(Logger $this, Seq key2, String verboseKeySuffix, String message) {
        $this.setPromptLine(key2, verboseKeySuffix, message);
    }

    default public void setPromptLine(Seq<String> key2, String verboseKeySuffix, String message) {
        this.ticker(new StringBuilder(1).append(key2.mkString("-")).append(" ").append(message).toString());
    }

    public static /* synthetic */ void setPromptLine$(Logger $this) {
        $this.setPromptLine();
    }

    default public void setPromptLine() {
    }

    public static /* synthetic */ void setPromptHeaderPrefix$(Logger $this, String s) {
        $this.setPromptHeaderPrefix(s);
    }

    default public void setPromptHeaderPrefix(String s) {
    }

    public static /* synthetic */ void clearPromptStatuses$(Logger $this) {
        $this.clearPromptStatuses();
    }

    default public void clearPromptStatuses() {
    }

    public static /* synthetic */ void removePromptLine$(Logger $this, Seq key2) {
        $this.removePromptLine(key2);
    }

    default public void removePromptLine(Seq<String> key2) {
    }

    public static /* synthetic */ void removePromptLine$(Logger $this) {
        $this.removePromptLine();
    }

    default public void removePromptLine() {
    }

    public static /* synthetic */ Object withPromptPaused$(Logger $this, Function0 t) {
        return $this.withPromptPaused(t);
    }

    default public <T> T withPromptPaused(Function0<T> t) {
        return t.apply();
    }

    public static /* synthetic */ Object withPromptUnpaused$(Logger $this, Function0 t) {
        return $this.withPromptUnpaused(t);
    }

    default public <T> T withPromptUnpaused(Function0<T> t) {
        return t.apply();
    }

    public static /* synthetic */ boolean debugEnabled$(Logger $this) {
        return $this.debugEnabled();
    }

    @Scaladoc(value="/**\n   * @since Mill 0.10.5\n   */")
    default public boolean debugEnabled() {
        return false;
    }

    public static /* synthetic */ void close$(Logger $this) {
        $this.close();
    }

    @Override
    default public void close() {
    }

    public static /* synthetic */ boolean enableTicker$(Logger $this) {
        return $this.enableTicker();
    }

    default public boolean enableTicker() {
        return false;
    }

    public static /* synthetic */ Logger subLogger$(Logger $this, Path path, String verboseKeySuffix, String message) {
        return $this.subLogger(path, verboseKeySuffix, message);
    }

    default public Logger subLogger(Path path, String verboseKeySuffix, String message) {
        return this;
    }

    public static /* synthetic */ Object withPrompt$(Logger $this, Function0 t) {
        return $this.withPrompt(t);
    }

    default public <T> T withPrompt(Function0<T> t) {
        T t2;
        this.setPromptLine();
        try {
            t2 = t.apply();
        }
        finally {
            this.removePromptLine();
        }
        return t2;
    }

    public static /* synthetic */ Logger withOutStream$(Logger $this, PrintStream outStream) {
        return $this.withOutStream(outStream);
    }

    default public Logger withOutStream(PrintStream outStream) {
        return this;
    }

    public static /* synthetic */ Seq logPrefixKey$(Logger $this) {
        return $this.logPrefixKey();
    }

    default public Seq<String> logPrefixKey() {
        return Nil$.MODULE$;
    }

    public static void $init$(Logger $this) {
    }
}

