/*
 * Decompiled with CFR 0.152.
 */
package plugin.network;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;
import plugin.network.NetworkModel;
import plugin.network.gui.NetworkView;

public class NetworkServer
extends Thread {
    private NetworkModel model;
    private static List<String> clients = new ArrayList<String>();
    boolean run = true;
    protected ServerSocket sock;

    public NetworkServer(NetworkModel model) {
        this.model = model;
    }

    @Override
    public void run() {
        try {
            this.startServer();
        }
        catch (UnknownHostException uhe) {
            this.model.getView().setConnectionText("Server Error", "Cannot determine local address");
        }
        catch (Exception e) {
            this.model.getView().setConnectionText("Server Error", e.getMessage());
        }
    }

    public void startServer() throws Exception {
        NetworkView view = this.model.getView();
        int port = SettingsHandler.getGMGenOption((String)"Network.port", (int)80);
        view.setConnectionText("Server Status", "Starting");
        InetAddress inetadr = InetAddress.getLocalHost();
        view.setLocalAddressText(inetadr.getHostAddress() + ":" + port);
        this.run = true;
        this.sock = new ServerSocket(port);
        view.setConnectionText("Server Status", "Started");
        while (this.run) {
            try {
                Socket clientSocket = this.sock.accept();
                new Handler(clientSocket).start();
            }
            catch (Exception e) {
                view.setConnectionText("Server Status", "Stopped");
            }
        }
        this.sock.close();
    }

    public void setRun(boolean run) {
        if (this.sock != null) {
            try {
                this.sock.close();
                this.run = run;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void sendRemoveUser(String user) {
        ThreadGroup tg = this.getThreadGroup();
        Thread[] tl = new Thread[tg.activeCount()];
        tg.enumerate(tl);
        for (Thread t : tl) {
            if (!(t instanceof Handler)) continue;
            ((Handler)t).sendRemoveUser(user);
        }
    }

    public void sendAllAddUser(String user) {
        ThreadGroup tg = this.getThreadGroup();
        Thread[] tl = new Thread[tg.activeCount()];
        tg.enumerate(tl);
        for (Thread t : tl) {
            if (!(t instanceof Handler)) continue;
            ((Handler)t).sendAddUser("GM");
            for (String client : clients) {
                ((Handler)t).sendAddUser(client);
            }
        }
    }

    public void sendIM(String source, String target, String text) {
        ThreadGroup tg = this.getThreadGroup();
        Thread[] tl = new Thread[tg.activeCount()];
        tg.enumerate(tl);
        for (Thread t : tl) {
            if (!(t instanceof Handler)) continue;
            if (target.equals("Broadcast")) {
                ((Handler)t).sendBroadcast(source, text);
                continue;
            }
            if (!((Handler)t).getUser().equals(target)) continue;
            ((Handler)t).sendIM(source, text);
        }
    }

    public void sendBroadcast(String user, String text) {
        ThreadGroup tg = this.getThreadGroup();
        Thread[] tl = new Thread[tg.activeCount()];
        tg.enumerate(tl);
        for (Thread t : tl) {
            if (!(t instanceof Handler)) continue;
            ((Handler)t).sendBroadcast(user, text);
        }
    }

    private String handleUserMessage(String message) throws Exception {
        for (String test : clients) {
            if (!test.equals(message)) continue;
            throw new Exception("User with the name of " + message + " already connected.  Go to Edit->Preferences in GMGen.  Under the network folder, set the User Name to a different value.");
        }
        clients.add(message);
        this.sendAllAddUser(message);
        this.model.addUser(message);
        this.model.log(message, "Network", "Connected");
        this.model.getView().setConnectionText("Server Status", message + " Connected.  " + clients.size() + " clients connected");
        return message;
    }

    private void handleExitMessage(String user) throws Exception {
        this.model.log(user, "Network", "Disconnected");
        for (String test : clients) {
            if (test.equals(user)) {
                clients.remove(test);
                break;
            }
            this.model.removeUser(user);
            this.sendRemoveUser(user);
        }
        throw new Exception("");
    }

    private void handleLogMessage(String user, String message) {
        String owner = "";
        String log = "";
        StringTokenizer st = new StringTokenizer(message, "|");
        if (st.hasMoreTokens()) {
            owner = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            log = st.nextToken();
        }
        this.model.log(user, owner, log);
    }

    private void handleIMMessage(String user, String message) {
        String owner = "";
        String log = "";
        StringTokenizer st = new StringTokenizer(message, "|");
        if (st.hasMoreTokens()) {
            owner = st.nextToken();
        }
        if (st.hasMoreTokens()) {
            log = st.nextToken();
        }
        if (owner.equals("GM")) {
            this.model.log(user, log);
        } else {
            this.model.log(user, "(to " + owner + ")", log);
            this.sendIM(user, owner, log);
        }
    }

    private void handleBroadcastMessage(String user, String message) {
        this.model.log(user, "BROADCAST", message);
        this.sendBroadcast(user, message);
    }

    private void handlePcgMessage(String message, Socket socket) {
        int num = message.indexOf(":");
        String uid = message.substring(0, num);
        String messagetext = message.substring(num + 1);
        this.model.handlePcgMessage(uid, messagetext, socket);
    }

    public String handleMessage(String message, Socket socket) throws Exception {
        String user = "Client";
        if (message.startsWith("User:")) {
            user = this.handleUserMessage(message.substring(6));
        } else {
            this.handleMessage(user, message, socket);
        }
        return user;
    }

    public String handleMessage(String user, String message, Socket socket) throws Exception {
        String retValue = "";
        if (message.startsWith("Exit:")) {
            this.handleExitMessage(user);
        } else if (message.startsWith("Log:")) {
            this.handleLogMessage(user, message.substring(5));
        } else if (message.startsWith("Pcg:")) {
            this.handlePcgMessage(message.substring(5), socket);
        } else if (message.startsWith("IM:")) {
            this.handleIMMessage(user, message.substring(4));
        } else if (message.startsWith("Broadcast:")) {
            this.handleBroadcastMessage(user, message.substring(11));
        } else {
            retValue = "Return: " + message;
        }
        return retValue;
    }

    protected class Handler
    extends Thread {
        Socket socket;
        PrintStream os = null;
        boolean isRun = true;
        String user = "Client";

        public Handler(Socket sock) {
            this.socket = sock;
        }

        private synchronized void sendMessage(String type, String message) {
            this.os.print(type + ": " + message + "\r\n");
            this.os.flush();
        }

        public void sendIM(String source, String message) {
            this.sendMessage("IM", source + "|" + message);
        }

        public void sendBroadcast(String aUser, String message) {
            this.sendMessage("Broadcast", aUser + "|" + message);
        }

        public void sendRemoveUser(String aUser) {
            this.sendMessage("RemoveUser", aUser);
        }

        public void sendAddUser(String aUser) {
            this.sendMessage("AddUser", aUser);
        }

        public void sendExitMessage() {
            this.sendMessage("Exit", "");
        }

        @Override
        public void run() {
            NetworkView view = NetworkServer.this.model.getView();
            try {
                String line;
                view.setConnectionText("Server Status", this.user + " Connected.  " + clients.size() + " clients connected");
                BufferedReader is = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), "UTF-8"));
                this.os = new PrintStream((OutputStream)new BufferedOutputStream(this.socket.getOutputStream()), true, "UTF-8");
                String disconnection = " Disconnected. ";
                while ((line = is.readLine()) != null) {
                    block8: {
                        String retString = "";
                        Logging.debugPrint((String)("Network message from Client: " + line));
                        try {
                            if (this.user.equals("Client")) {
                                this.user = NetworkServer.this.handleMessage(line, this.socket);
                            } else {
                                retString = NetworkServer.this.handleMessage(this.user, line, this.socket);
                            }
                            if (retString.equals("")) break block8;
                            this.os.print(retString + "\r\n");
                            this.os.flush();
                        }
                        catch (Exception e) {
                            if (e.getMessage().equals("")) break;
                            disconnection = " Disconnected, " + e.getMessage() + ". ";
                            this.os.print("Error: " + e.getMessage());
                            this.os.flush();
                            break;
                        }
                    }
                    if (this.isRun) continue;
                    break;
                }
                this.os.close();
                is.close();
                this.socket.close();
                view.setConnectionText("Server Status", this.user + disconnection + clients.size() + " clients connected");
            }
            catch (Exception e) {
                for (String test : clients) {
                    if (!test.equals(this.user)) continue;
                    clients.remove(test);
                    break;
                }
                view.setConnectionText("Server Error", "IO Error on socket");
                return;
            }
        }

        public void setRun(boolean run) {
            this.sendExitMessage();
        }

        public Socket getSocket() {
            return this.socket;
        }

        public PrintStream getOutputStream() {
            return this.os;
        }

        public String getUser() {
            return this.user;
        }

        public void setOutputStream(PrintStream os) {
            this.os = os;
        }

        public void setUser(String user) {
            this.user = user;
        }
    }
}

