/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.gui.plaf.skin;

import com.l2fprod.gui.plaf.skin.Skin;
import com.l2fprod.gui.plaf.skin.SkinLookAndFeel;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.text.View;

public class SkinButtonUI
extends BasicButtonUI {
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    protected Color focusColor;
    protected Skin skin = SkinLookAndFeel.getSkin();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return new SkinButtonUI();
    }

    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        SkinButtonUI.viewRect.x = i.left;
        SkinButtonUI.viewRect.y = i.top;
        SkinButtonUI.viewRect.width = b.getWidth() - (i.right + SkinButtonUI.viewRect.x);
        SkinButtonUI.viewRect.height = b.getHeight() - (i.bottom + SkinButtonUI.viewRect.y);
        SkinButtonUI.textRect.height = 0;
        SkinButtonUI.textRect.width = 0;
        SkinButtonUI.textRect.y = 0;
        SkinButtonUI.textRect.x = 0;
        SkinButtonUI.iconRect.height = 0;
        SkinButtonUI.iconRect.width = 0;
        SkinButtonUI.iconRect.y = 0;
        SkinButtonUI.iconRect.x = 0;
        Font f = c.getFont();
        g.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : this.defaultTextIconGap);
        this.clearTextShiftOffset();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g, b);
        }
        this.skin.getButton().paintButton(g, b);
        if (b.getIcon() != null) {
            this.paintIcon(g, c, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, c, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        String pp = this.getPropertyPrefix();
        this.dashedRectGapX = UIManager.getInt(pp + "dashedRectGapX");
        this.dashedRectGapY = UIManager.getInt(pp + "dashedRectGapY");
        this.dashedRectGapWidth = UIManager.getInt(pp + "dashedRectGapWidth");
        this.dashedRectGapHeight = UIManager.getInt(pp + "dashedRectGapHeight");
        this.focusColor = UIManager.getColor(pp + "focus");
        b.setBorderPainted(false);
        b.setFocusPainted(true);
        b.setOpaque(false);
        b.setRolloverEnabled(true);
        this.skin.getButton().installSkin(b);
    }

    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        b.setBorderPainted(true);
        b.setFocusPainted(true);
        b.setOpaque(true);
    }

    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        int width = b.getWidth();
        int height = b.getHeight();
        g.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(g, this.dashedRectGapX, this.dashedRectGapY, width - this.dashedRectGapWidth, height - this.dashedRectGapHeight);
    }

    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.setTextShiftOffset();
    }
}

