/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.spell;

import java.util.Collection;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.spell.Spell;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractTokenWithSeparator;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class CompsToken
extends AbstractTokenWithSeparator<Spell>
implements CDOMPrimaryToken<Spell> {
    @Override
    public String getTokenName() {
        return "COMPS";
    }

    @Override
    protected char separator() {
        return '|';
    }

    @Override
    protected ParseResult parseTokenWithSeparator(LoadContext context, Spell spell, String value) {
        StringTokenizer aTok = new StringTokenizer(value, "|");
        boolean first = true;
        while (aTok.hasMoreTokens()) {
            String tok = aTok.nextToken();
            if (".CLEAR".equals(tok)) {
                if (!first) {
                    return new ParseResult.Fail("Non-sensical use of .CLEAR in " + this.getTokenName() + ": " + value, context);
                }
                context.getObjectContext().removeList(spell, ListKey.COMPONENTS);
            } else {
                context.getObjectContext().addToList(spell, ListKey.COMPONENTS, tok);
            }
            first = false;
        }
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, Spell spell) {
        Changes<String> changes = context.getObjectContext().getListChanges(spell, ListKey.COMPONENTS);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Collection<String> added = changes.getAdded();
        boolean globalClear = changes.includesGlobalClear();
        if (globalClear) {
            sb.append(".CLEAR");
        }
        if (added != null && !added.isEmpty()) {
            if (globalClear) {
                sb.append("|");
            }
            sb.append(StringUtil.join(added, (String)"|"));
        }
        if (sb.length() == 0) {
            context.addWriteMessage(this.getTokenName() + " was expecting non-empty changes to include " + "added items or global clear");
            return null;
        }
        return new String[]{sb.toString()};
    }

    @Override
    public Class<Spell> getTokenClass() {
        return Spell.class;
    }
}

