/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.equip;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.EquipmentListFacade;
import pcgen.facade.core.EquipmentSetFacade;
import pcgen.facade.util.AbstractListFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.facade.util.event.ReferenceEvent;
import pcgen.facade.util.event.ReferenceListener;
import pcgen.util.Logging;

public class UnequippedList
extends AbstractListFacade<EquipmentFacade>
implements EquipmentListFacade,
EquipmentListFacade.EquipmentListListener,
ListListener<EquipmentFacade>,
ReferenceListener<EquipmentSetFacade> {
    private final CharacterFacade character;
    private final EquipmentListFacade purchasedList;
    private final List<EquipmentFacade> equipmentList;
    private final Map<EquipmentFacade, Integer> quantityMap;
    private EquipmentListFacade equippedList;
    private EquipmentFacade lastRemoved;

    public UnequippedList(CharacterFacade character) {
        this.character = character;
        this.purchasedList = character.getPurchasedEquipment();
        this.equipmentList = new ArrayList<EquipmentFacade>();
        this.quantityMap = new HashMap<EquipmentFacade, Integer>();
        ReferenceFacade<EquipmentSetFacade> ref = character.getEquipmentSetRef();
        this.equippedList = ref.getReference().getEquippedItems();
        for (EquipmentFacade equipment : this.purchasedList) {
            int quantity = this.purchasedList.getQuantity(equipment) - this.equippedList.getQuantity(equipment);
            if (quantity <= 0) continue;
            this.equipmentList.add(equipment);
            this.quantityMap.put(equipment, quantity);
        }
        this.purchasedList.addListListener(this);
        this.purchasedList.addEquipmentListListener(this);
        this.equippedList.addListListener(this);
        this.equippedList.addEquipmentListListener(this);
        ref.addReferenceListener(this);
    }

    @Override
    public EquipmentFacade getElementAt(int index) {
        return this.equipmentList.get(index);
    }

    @Override
    public int getSize() {
        return this.equipmentList.size();
    }

    @Override
    public int getQuantity(EquipmentFacade equipment) {
        if (this.quantityMap.containsKey(equipment)) {
            return this.quantityMap.get(equipment);
        }
        return 0;
    }

    @Override
    public void addEquipmentListListener(EquipmentListFacade.EquipmentListListener listener) {
        this.listenerList.add(EquipmentListFacade.EquipmentListListener.class, listener);
    }

    @Override
    public void removeEquipmentListListener(EquipmentListFacade.EquipmentListListener listener) {
        this.listenerList.remove(EquipmentListFacade.EquipmentListListener.class, listener);
    }

    @Override
    public void referenceChanged(ReferenceEvent<EquipmentSetFacade> e) {
        this.equippedList.removeListListener(this);
        this.equippedList.removeEquipmentListListener(this);
        this.equippedList = e.getNewReference().getEquippedItems();
        this.equippedList.addListListener(this);
        this.equippedList.addEquipmentListListener(this);
        this.elementsChanged((ListEvent<EquipmentFacade>)null);
    }

    private void addEquipment(EquipmentFacade equipment, int quantity) {
        this.equipmentList.add(equipment);
        this.quantityMap.put(equipment, quantity);
        this.fireElementAdded(this, equipment, this.equipmentList.size() - 1);
    }

    private void setQuantity(EquipmentFacade equipment, int quantity) {
        this.quantityMap.put(equipment, quantity);
        this.fireQuantityChangedEvent(this, equipment, quantity);
    }

    private void removeEquipment(EquipmentFacade equipment) {
        int index = this.equipmentList.indexOf(equipment);
        if (index >= 0) {
            this.equipmentList.remove(index);
            this.quantityMap.remove(equipment);
            this.fireElementRemoved(this, equipment, index);
        }
    }

    @Override
    public void elementAdded(ListEvent<EquipmentFacade> e) {
        EquipmentFacade equipment = e.getElement();
        if (e.getSource() == this.purchasedList) {
            this.lastRemoved = null;
            this.addEquipment(equipment, this.purchasedList.getQuantity(equipment));
        } else {
            int quantity = this.purchasedList.getQuantity(equipment) - this.equippedList.getQuantity(equipment);
            if (quantity > 0) {
                this.setQuantity(equipment, quantity);
            } else {
                this.removeEquipment(equipment);
            }
        }
    }

    @Override
    public void elementRemoved(ListEvent<EquipmentFacade> e) {
        EquipmentFacade equipment = e.getElement();
        if (e.getSource() == this.purchasedList) {
            this.removeEquipment(equipment);
            this.lastRemoved = equipment;
        } else {
            if (equipment.equals(this.lastRemoved)) {
                if (Logging.isDebugMode()) {
                    Logging.debugPrint("Ignoring unequip of item just removed: " + equipment);
                }
                return;
            }
            int quantity = this.purchasedList.getQuantity(equipment) - this.equippedList.getQuantity(equipment);
            if (this.quantityMap.containsKey(equipment)) {
                this.setQuantity(equipment, quantity);
            } else {
                this.addEquipment(equipment, quantity);
            }
        }
    }

    @Override
    public void elementsChanged(ListEvent<EquipmentFacade> e) {
        this.equipmentList.clear();
        this.quantityMap.clear();
        for (EquipmentFacade equipment : this.purchasedList) {
            int quantity = this.purchasedList.getQuantity(equipment) - this.equippedList.getQuantity(equipment);
            if (quantity <= 0) continue;
            this.equipmentList.add(equipment);
            this.quantityMap.put(equipment, quantity);
        }
        this.fireElementsChanged(this);
    }

    @Override
    public void elementModified(ListEvent<EquipmentFacade> e) {
    }

    @Override
    public void quantityChanged(EquipmentListFacade.EquipmentListEvent e) {
        EquipmentFacade equipment = e.getEquipment();
        int quantity = this.purchasedList.getQuantity(equipment) - this.equippedList.getQuantity(equipment);
        if (quantity > 0) {
            if (this.quantityMap.containsKey(equipment)) {
                this.setQuantity(equipment, quantity);
            } else {
                this.addEquipment(equipment, quantity);
            }
        } else {
            this.removeEquipment(equipment);
        }
    }

    private void fireQuantityChangedEvent(Object source, EquipmentFacade equipment, int index) {
        Object[] listeners = this.listenerList.getListenerList();
        EquipmentListFacade.EquipmentListEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EquipmentListFacade.EquipmentListListener.class) continue;
            if (e == null) {
                e = new EquipmentListFacade.EquipmentListEvent(source, equipment, index);
            }
            ((EquipmentListFacade.EquipmentListListener)listeners[i + 1]).quantityChanged(e);
        }
    }

    @Override
    public void modifyElement(EquipmentFacade equipment) {
    }
}

