/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.display;

import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.display.CharacterDisplay;
import pcgen.util.Delta;

public class UnarmedDamageDisplay {
    public static String getUnarmedDamageString(PlayerCharacter pc, boolean includeStrBonus, boolean adjustForPCSize) {
        CharacterDisplay display = pc.getDisplay();
        String retString = "2|1d2";
        for (PCClass pcClass : display.getClassSet()) {
            retString = UnarmedDamageDisplay.getBestUDamString(retString, pcClass.getUdamForLevel(display.getLevel(pcClass), pc, adjustForPCSize));
        }
        int sizeInt = adjustForPCSize ? display.sizeInt() : display.racialSizeInt();
        for (List<String> unarmedDamage : display.getUnarmedDamage()) {
            String aDamage = unarmedDamage.size() == 1 ? unarmedDamage.get(0) : unarmedDamage.get(sizeInt);
            retString = UnarmedDamageDisplay.getBestUDamString(retString, aDamage);
        }
        String pObjDamage = display.getUDamForRace();
        retString = UnarmedDamageDisplay.getBestUDamString(retString, pObjDamage);
        StringBuilder ret = new StringBuilder(retString.substring(retString.indexOf(124) + 1));
        if (includeStrBonus) {
            int sb = (int)display.getStatBonusTo("DAMAGE", "TYPE.MELEE");
            if ((sb += (int)display.getStatBonusTo("DAMAGE", "TYPE=MELEE")) != 0) {
                ret.append(Delta.toString(sb));
            }
        }
        return ret.toString();
    }

    public static String getBestUDamString(String oldString, String newString) {
        if (newString == null || newString.length() < 2) {
            return oldString;
        }
        if (oldString == null) {
            StringTokenizer aTok = new StringTokenizer(newString, " dD+-(x)");
            aTok.nextToken();
            return Integer.parseInt(aTok.nextToken()) + "|" + newString;
        }
        StringTokenizer aTok = new StringTokenizer(oldString, "|");
        int sides = Integer.parseInt(aTok.nextToken());
        String retString = oldString;
        aTok = new StringTokenizer(newString, " dD+-(x)");
        if (aTok.countTokens() > 1) {
            aTok.nextToken();
            int i = Integer.parseInt(aTok.nextToken());
            if (sides < i) {
                sides = i;
                retString = sides + "|" + newString;
            }
        }
        return retString;
    }
}

