/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.meta;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.cdom.enumeration.CharID;
import pcgen.cdom.facet.base.AbstractItemConvertingFacet;
import pcgen.cdom.meta.FacetView;

public class ConvertingFacetView<S, D>
implements FacetView<Object> {
    private AbstractItemConvertingFacet<S, D> facet;

    public ConvertingFacetView(AbstractItemConvertingFacet<S, D> facet) {
        this.facet = facet;
    }

    @Override
    public Collection<? extends Object> getSet(CharID id) {
        Collection<S> sources = this.facet.getSourceObjects(id);
        ArrayList<SourceDest> list = new ArrayList<SourceDest>(sources.size());
        for (S src : sources) {
            D dest = this.facet.getResultFor(id, src);
            list.add(new SourceDest(src, dest));
        }
        return list;
    }

    @Override
    public Collection<Object> getSources(CharID id, Object obj) {
        return this.facet.getSourcesFor(id, ((SourceDest)obj).source);
    }

    @Override
    public Object[] getChildren() {
        return this.facet.getDataFacetChangeListeners();
    }

    @Override
    public String getDescription() {
        return this.facet.getClass().getSimpleName();
    }

    @Override
    public boolean represents(Object src) {
        return this.facet.equals(src);
    }

    public String toString() {
        return "Facet: " + this.facet.getClass().getSimpleName();
    }

    private class SourceDest {
        S source;
        D destination;

        public SourceDest(S source, D destination) {
            this.source = source;
            this.destination = destination;
        }

        public String toString() {
            return this.source + " -> " + this.destination;
        }
    }
}

