/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import pcgen.base.util.ListSet;
import pcgen.cdom.base.PrereqObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.prereq.PrerequisiteUtilities;

public class ConcretePrereqObject
implements Cloneable,
PrereqObject {
    private Set<Prerequisite> thePrereqs = null;

    @Override
    public List<Prerequisite> getPrerequisiteList() {
        if (this.thePrereqs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<Prerequisite>(this.thePrereqs));
    }

    public final boolean hasPreReqTypeOf(String matchType) {
        if (!this.hasPrerequisites()) {
            return false;
        }
        for (Prerequisite prereq : this.getPrerequisiteList()) {
            if (!PrerequisiteUtilities.hasPreReqKindOf(prereq, matchType)) continue;
            return true;
        }
        return false;
    }

    public ConcretePrereqObject clone() throws CloneNotSupportedException {
        ConcretePrereqObject obj = (ConcretePrereqObject)super.clone();
        if (this.thePrereqs != null) {
            obj.thePrereqs = new ListSet();
            obj.thePrereqs.addAll(this.thePrereqs);
        }
        return obj;
    }

    @Override
    public void addAllPrerequisites(Collection<Prerequisite> prereqs) {
        if (prereqs == null || prereqs.isEmpty()) {
            return;
        }
        if (this.thePrereqs == null) {
            this.thePrereqs = new ListSet(prereqs.size());
        }
        for (Prerequisite pre : prereqs) {
            this.addPrerequisite(pre);
        }
    }

    @Override
    public void addPrerequisite(Prerequisite preReq) {
        if (preReq == null) {
            return;
        }
        if (this.thePrereqs == null) {
            this.thePrereqs = new ListSet();
        }
        this.thePrereqs.add(preReq);
    }

    @Override
    public void clearPrerequisiteList() {
        this.thePrereqs = null;
    }

    @Override
    public int getPrerequisiteCount() {
        if (this.thePrereqs == null) {
            return 0;
        }
        return this.thePrereqs.size();
    }

    @Override
    public boolean hasPrerequisites() {
        return this.thePrereqs != null;
    }

    public boolean equalsPrereqObject(PrereqObject other) {
        if (this == other) {
            return true;
        }
        boolean otherHas = other.hasPrerequisites();
        if (!this.hasPrerequisites()) {
            return !otherHas;
        }
        if (!otherHas) {
            return false;
        }
        List<Prerequisite> otherPRL = other.getPrerequisiteList();
        if (otherPRL.size() != this.thePrereqs.size()) {
            return false;
        }
        ArrayList<Prerequisite> removed = new ArrayList<Prerequisite>(this.thePrereqs);
        removed.removeAll(otherPRL);
        return removed.isEmpty();
    }

    public boolean qualifies(PlayerCharacter aPC, Object owner) {
        return !this.hasPrerequisites() || PrereqHandler.passesAll(this.getPrerequisiteList(), aPC, owner);
    }
}

