/* arch-tag: ef126cd3-9cee-42c8-9bea-9a35dda8db85 */

/*  eXperience GTK engine: filter.h
 *  
 *  Copyright (C) 2004-2005  Benjamin Berg <benjamin@sipsolutions.net>
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __FILTER_H
#define __FILTER_H

#include <glib.h>
#include <gtk/gtk.h>
#include "utils.h"
#include "dynamic_color.h"

typedef enum {
	FILTER_NONE = 0,
	FILTER_SATURATION   = 1 << 0,
	FILTER_BRIGHTNESS   = 1 << 1,
	FILTER_OPACITY      = 1 << 2,
	FILTER_PIXELATE     = 1 << 3,
	FILTER_ROTATE       = 1 << 4,
	FILTER_MIRROR       = 1 << 5,
	FILTER_RECOLOR      = 1 << 6,
} eXperienceFilterList;

#define FILTER_ALL (FILTER_SATURATION | FILTER_BRIGHTNESS | FILTER_OPACITY | FILTER_PIXELATE | FILTER_ROTATE | FILTER_MIRROR | FILTER_RECOLOR)

typedef enum {
	RECOLOR_NONE,
	RECOLOR_SIMPLE_REPLACE,
	RECOLOR_RGB_GRADIENT
} eXperienceRecolorMode;

struct _filter {
	eXperienceFilterList allowed;
	eXperienceFilterList defined;

	gfloat saturation;
	gfloat brightness; 
	gfloat opacity;
	gboolean pixelate;
	
	eXperienceRoundingMethod rounding;
	
	eXperienceOrientation mirror;
	eXperienceRotate rotation;
	
	eXperienceRecolorMode recolor_mode;
	GHashTable * recolor_colors;
	
	gchar * info_string;
};
typedef struct _filter eXperienceFilter;


void experience_filter_init (eXperienceFilter * filter, eXperienceFilterList allowed_filters) EXPERIENCE_INTERNAL;
void experience_filter_set_info_string (eXperienceFilter * filter, gchar * info_string) EXPERIENCE_INTERNAL;
guint experience_filter_hash (eXperienceFilter * filter, guint hash_value) EXPERIENCE_INTERNAL;
gboolean experience_filter_equal (eXperienceFilter * filter1, eXperienceFilter * filter2) EXPERIENCE_INTERNAL;
void experience_filter_inherit_from (eXperienceFilter * filter, eXperienceFilter * from) EXPERIENCE_INTERNAL;
void experience_filter_apply_group_filter (eXperienceFilter * filter, eXperienceFilter * group_filter) EXPERIENCE_INTERNAL;

void experience_filter_set_saturation (eXperienceFilter * filter, gfloat value) EXPERIENCE_INTERNAL;
void experience_filter_set_opacity    (eXperienceFilter * filter, gfloat value) EXPERIENCE_INTERNAL;
void experience_filter_set_brightness (eXperienceFilter * filter, gfloat value) EXPERIENCE_INTERNAL;
void experience_filter_set_pixelate   (eXperienceFilter * filter, gboolean value) EXPERIENCE_INTERNAL;

void experience_filter_add_recolor_color (eXperienceFilter * filter, GdkColor color, eXperienceDynamicColor recolor_color) EXPERIENCE_INTERNAL;
void experience_filter_set_recolor_gradient (eXperienceFilter * filter, eXperienceDynamicColor red, eXperienceDynamicColor green, eXperienceDynamicColor blue) EXPERIENCE_INTERNAL;

void experience_filter_add_mirror (eXperienceFilter * filter, eXperienceOrientation mirror) EXPERIENCE_INTERNAL;
void experience_filter_set_rotation (eXperienceFilter * filter, eXperienceRotate rotation) EXPERIENCE_INTERNAL;

/*-------*/

GdkPixbuf * experience_apply_filters (GdkPixbuf * experience, eXperienceFilter * filter) EXPERIENCE_INTERNAL;

void experience_apply_filter_to_color (GdkColor * color, eXperienceFilter * filter) EXPERIENCE_INTERNAL;

void experience_retrieve_recolor_colors (eXperienceFilter * filter, GtkStyle * style) EXPERIENCE_INTERNAL;

GdkColor * experience_filter_get_recolor_color (eXperienceFilter * filter, GdkColor * color) EXPERIENCE_INTERNAL;

void experience_filter_finalize (eXperienceFilter * filter) EXPERIENCE_INTERNAL;
void experience_filter_copy (eXperienceFilter * dest, eXperienceFilter * source) EXPERIENCE_INTERNAL;

#endif /* __FILTER_H */
