/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.JvmOptions;
import org.gradle.process.internal.util.MergeOptionsUtil;

@NonNullApi
public class EffectiveJavaForkOptions {
    private final String executable;
    private final File workingDir;
    private final Map<String, Object> environment;
    private final ReadOnlyJvmOptions jvmOptions;

    public EffectiveJavaForkOptions(String executable, File workingDir, Map<String, Object> environment, JvmOptions jvmOptions) {
        this.executable = executable;
        this.workingDir = workingDir;
        this.environment = ImmutableMap.copyOf(environment);
        this.jvmOptions = new ReadOnlyJvmOptions(jvmOptions);
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public String getExecutable() {
        return this.executable;
    }

    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public ReadOnlyJvmOptions getJvmOptions() {
        return this.jvmOptions;
    }

    public boolean isCompatibleWith(EffectiveJavaForkOptions forkOptions) {
        return this.jvmOptions.getDebug() == forkOptions.getJvmOptions().getDebug() && this.jvmOptions.getEnableAssertions() == forkOptions.getJvmOptions().getEnableAssertions() && MergeOptionsUtil.normalized(this.executable).equals(MergeOptionsUtil.normalized(forkOptions.getExecutable())) && this.workingDir.equals(forkOptions.getWorkingDir()) && MergeOptionsUtil.normalized(this.jvmOptions.getDefaultCharacterEncoding()).equals(MergeOptionsUtil.normalized(forkOptions.getJvmOptions().getDefaultCharacterEncoding())) && MergeOptionsUtil.getHeapSizeMb(this.jvmOptions.getMinHeapSize()) >= MergeOptionsUtil.getHeapSizeMb(forkOptions.getJvmOptions().getMinHeapSize()) && MergeOptionsUtil.getHeapSizeMb(this.jvmOptions.getMaxHeapSize()) >= MergeOptionsUtil.getHeapSizeMb(forkOptions.getJvmOptions().getMaxHeapSize()) && MergeOptionsUtil.normalized(this.jvmOptions.getJvmArgs()).containsAll(MergeOptionsUtil.normalized(forkOptions.getJvmOptions().getJvmArgs())) && MergeOptionsUtil.containsAll(this.jvmOptions.getMutableSystemProperties(), forkOptions.getJvmOptions().getMutableSystemProperties()) && MergeOptionsUtil.containsAll(this.environment, forkOptions.getEnvironment()) && this.jvmOptions.getBootstrapClasspath().getFiles().containsAll(forkOptions.getJvmOptions().getBootstrapClasspath().getFiles());
    }

    public void copyTo(JavaExecHandleBuilder target) {
        target.setExecutable(this.executable);
        target.setWorkingDir(this.workingDir);
        target.setEnvironment(this.environment);
        target.copyJavaForkOptions(this.jvmOptions);
    }

    public String toString() {
        return "EffectiveJavaForkOptions{executable='" + this.executable + '\'' + ", workingDir=" + this.workingDir + ", environment=" + this.environment + ", jvmOptions=" + this.jvmOptions + '}';
    }

    @NonNullApi
    public static class ReadOnlyJvmOptions {
        private final JvmOptions delegate;

        public ReadOnlyJvmOptions(JvmOptions delegate) {
            this.delegate = delegate;
        }

        public String getMinHeapSize() {
            return this.delegate.getMinHeapSize();
        }

        public String getMaxHeapSize() {
            return this.delegate.getMaxHeapSize();
        }

        public boolean getDebug() {
            return this.delegate.getDebug();
        }

        public boolean getEnableAssertions() {
            return this.delegate.getEnableAssertions();
        }

        public String getDefaultCharacterEncoding() {
            return this.delegate.getDefaultCharacterEncoding();
        }

        public FileCollection getBootstrapClasspath() {
            return this.delegate.getBootstrapClasspath();
        }

        public List<String> getJvmArgs() {
            return ImmutableList.copyOf(this.delegate.getJvmArgs());
        }

        public List<String> getAllJvmArgs() {
            return ImmutableList.copyOf(this.delegate.getAllJvmArgs());
        }

        public Map<String, Object> getMutableSystemProperties() {
            return ImmutableMap.copyOf(this.delegate.getMutableSystemProperties());
        }

        public void copyTo(JavaForkOptions target) {
            this.delegate.copyTo(target);
        }
    }
}

