/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.weapons;

import java.util.Vector;
import megamek.common.IGame;
import megamek.common.Report;
import megamek.common.ToHitData;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.weapons.UltraWeaponHandler;
import megamek.server.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RACHandler
extends UltraWeaponHandler {
    private static final long serialVersionUID = -4859480151505343638L;

    public RACHandler(ToHitData toHitData, WeaponAttackAction weaponAttackAction, IGame iGame, Server server) {
        super(toHitData, weaponAttackAction, iGame, server);
    }

    @Override
    protected boolean doChecks(Vector<Report> vector) {
        boolean bl = false;
        switch (this.howManyShots) {
            case 6: {
                if (this.roll > 4) break;
                bl = true;
                break;
            }
            case 4: 
            case 5: {
                if (this.roll > 3) break;
                bl = true;
                break;
            }
            case 2: 
            case 3: {
                if (this.roll > 2) break;
                bl = true;
                break;
            }
        }
        if (bl) {
            this.r = new Report(3160);
            this.r.subject = this.subjectId;
            this.r.add(" shot(s)");
            vector.addElement(this.r);
            this.weapon.setJammed(true);
            return false;
        }
        return false;
    }

    @Override
    protected void useAmmo() {
        this.setDone();
        this.checkAmmo();
        if (this.weapon.curMode().equals("6-shot")) {
            this.howManyShots = 6;
        } else if (this.weapon.curMode().equals("5-shot")) {
            this.howManyShots = 5;
        } else if (this.weapon.curMode().equals("4-shot")) {
            this.howManyShots = 4;
        } else if (this.weapon.curMode().equals("3-shot")) {
            this.howManyShots = 3;
        } else if (this.weapon.curMode().equals("2-shot")) {
            this.howManyShots = 2;
        } else if (this.weapon.curMode().equals("Single")) {
            this.howManyShots = 1;
        }
        int n = this.ae.getTotalAmmoOfType(this.ammo.getType());
        int n2 = n >= 6 ? 6 : (n >= 5 ? 5 : (n >= 3 ? 3 : (n >= 2 ? 2 : 1)));
        if (n2 < this.howManyShots) {
            this.howManyShots = n2;
        }
        int n3 = this.howManyShots;
        if (this.ammo.getShotsLeft() == 0) {
            this.ae.loadWeapon(this.weapon);
            this.ammo = this.weapon.getLinked();
        }
        while (n3 > this.ammo.getShotsLeft()) {
            n3 -= this.ammo.getShotsLeft();
            this.ammo.setShotsLeft(0);
            this.ae.loadWeapon(this.weapon);
            this.ammo = this.weapon.getLinked();
        }
        this.ammo.setShotsLeft(this.ammo.getShotsLeft() - n3);
    }

    @Override
    protected boolean usesClusterTable() {
        return true;
    }

    @Override
    protected boolean canDoDirectBlowDamage() {
        return false;
    }
}

