/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.Serializable;
import megamek.common.IGame;

public class SpecialHexDisplay
implements Serializable {
    private static final long serialVersionUID = 27470795993329492L;
    private String info;
    private Type type;
    private int round;
    private String owner = null;
    private boolean obscured = true;
    public static int NO_ROUND = -99;

    private SpecialHexDisplay() {
    }

    public SpecialHexDisplay(Type type) {
        this.type = type;
        this.round = NO_ROUND;
    }

    public SpecialHexDisplay(Type type, String string) {
        this.type = type;
        this.info = string;
        this.round = NO_ROUND;
    }

    public SpecialHexDisplay(Type type, int n, String string) {
        this.type = type;
        this.info = string;
        this.round = n;
    }

    public SpecialHexDisplay(Type type, int n, String string, String string2) {
        this.type = type;
        this.info = string2;
        this.round = n;
        this.owner = string;
    }

    public SpecialHexDisplay(Type type, int n, String string, String string2, boolean bl) {
        this.type = type;
        this.info = string2;
        this.round = n;
        this.owner = string;
        this.obscured = bl;
    }

    public boolean thisRound(int n) {
        if (NO_ROUND == this.round) {
            return true;
        }
        return n == this.round;
    }

    public boolean futureRound(int n) {
        if (NO_ROUND == this.round) {
            return true;
        }
        return n > this.round;
    }

    public boolean pastRound(int n) {
        if (NO_ROUND == this.round) {
            return true;
        }
        return n < this.round;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String string) {
        this.info = string;
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n) {
        this.round = n;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public boolean isObscured() {
        return this.obscured;
    }

    public void setObscured(boolean bl) {
        this.obscured = bl;
    }

    public boolean drawNow(IGame.Phase phase, int n) {
        boolean bl;
        boolean bl2 = bl = this.thisRound(n) || this.pastRound(n) && this.type.drawBefore() || this.futureRound(n) && this.type.drawAfter();
        if (phase.isBefore(IGame.Phase.PHASE_OFFBOARD) && (this.type == Type.ARTILLERY_TARGET || this.type == Type.ARTILLERY_HIT)) {
            bl = bl || this.thisRound(n - 1);
        }
        return bl;
    }

    public boolean isOwner(String string) {
        return this.owner == null || this.owner.equals(string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ARTILLERY_AUTOHIT("data/images/hexes/artyauto.gif"){

            public boolean drawBefore() {
                return false;
            }

            public boolean drawAfter() {
                return true;
            }
        }
        ,
        ARTILLERY_ADJUSTED("data/images/hexes/artyadj.gif"){

            public boolean drawBefore() {
                return false;
            }

            public boolean drawAfter() {
                return true;
            }
        }
        ,
        ARTILLERY_INCOMING("data/images/hexes/artyinc.gif"),
        ARTILLERY_TARGET("data/images/hexes/artytarget.gif"){

            public boolean drawBefore() {
                return false;
            }
        }
        ,
        ARTILLERY_HIT("data/images/hexes/artyhit.gif"){

            public boolean drawBefore() {
                return false;
            }
        }
        ,
        PLAYER_NOTE(null);

        private transient Image defaultImage;
        private final String defaultImagePath;

        private Type(String string2) {
            this.defaultImagePath = string2;
        }

        public void init(Toolkit toolkit) {
            if (this.defaultImagePath != null) {
                this.defaultImage = toolkit.getImage(this.defaultImagePath);
            }
        }

        public Image getDefaultImage() {
            return this.defaultImage;
        }

        public void setDefaultImage(Image image) {
            this.defaultImage = image;
        }

        public boolean drawBefore() {
            return true;
        }

        public boolean drawAfter() {
            return false;
        }
    }
}

