/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing.widget;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import megamek.client.ui.swing.widget.PMHotArea;

public class PMSimplePolygonArea
implements PMHotArea {
    private ActionListener actionListener = null;
    public Color backColor = Color.lightGray;
    public Color normalBorderColor = Color.black;
    public Color highlightBorderColor = Color.red;
    private boolean highlight = true;
    private Polygon areaShape;
    private boolean selected = false;
    private boolean visible = true;
    private Cursor cursor = new Cursor(12);

    public PMSimplePolygonArea(Polygon polygon, Color color, Color color2, Color color3, boolean bl) {
        this.areaShape = polygon;
        if (color != null) {
            this.backColor = color;
        }
        if (color2 != null) {
            this.normalBorderColor = color2;
        }
        if (color3 != null) {
            this.highlightBorderColor = color3;
        }
        this.highlight = bl;
    }

    public PMSimplePolygonArea(Polygon polygon, Color color, Color color2) {
        this(polygon, color, color2, null, false);
    }

    public PMSimplePolygonArea(Polygon polygon) {
        this(polygon, null, null, null, true);
    }

    public void translate(int n, int n2) {
        this.areaShape.translate(n, n2);
    }

    public Rectangle getBounds() {
        return this.areaShape.getBounds();
    }

    public void drawInto(Graphics graphics) {
        if (graphics == null || !this.visible) {
            return;
        }
        Color color = graphics.getColor();
        graphics.setColor(this.backColor);
        graphics.fillPolygon(this.areaShape);
        if (this.selected && this.highlight) {
            graphics.setColor(this.highlightBorderColor);
        } else {
            graphics.setColor(this.normalBorderColor);
        }
        graphics.drawPolygon(this.areaShape);
        graphics.setColor(color);
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public Shape getAreaShape() {
        return this.areaShape;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public void onMouseClick(MouseEvent mouseEvent) {
    }

    public void onMouseOver(MouseEvent mouseEvent) {
        if (this.highlight) {
            this.selected = true;
        }
    }

    public void onMouseExit(MouseEvent mouseEvent) {
        if (this.highlight) {
            this.selected = false;
        }
    }

    public void onMouseDown(MouseEvent mouseEvent) {
    }

    public void onMouseUp(MouseEvent mouseEvent) {
    }
}

