/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import megamek.client.ui.Messages;
import megamek.common.preference.IClientPreferences;
import megamek.common.preference.PreferenceManager;

public class HostDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -103094006944170081L;
    public String playerName;
    public String serverPass;
    public int port;
    private boolean register;
    private String metaserver;
    private int goalPlayers;
    private JLabel yourNameL = new JLabel(Messages.getString("MegaMek.yourNameL"), 4);
    private JLabel serverPassL = new JLabel(Messages.getString("MegaMek.serverPassL"), 4);
    private JLabel portL = new JLabel(Messages.getString("MegaMek.portL"), 4);
    JTextField yourNameF = new JTextField(PreferenceManager.getClientPreferences().getLastPlayerName(), 16);
    private JTextField serverPassF;
    private JTextField portF;
    private JCheckBox registerC;
    JLabel metaserverL;
    JTextField metaserverF;
    JLabel goalL;
    JTextField goalF;
    private JButton okayB;
    private JButton cancelB;

    public HostDialog(JFrame jFrame) {
        super(jFrame, Messages.getString("MegaMek.HostDialog.title"), true);
        this.yourNameF.addActionListener(this);
        this.serverPassF = new JTextField(PreferenceManager.getClientPreferences().getLastServerPass(), 16);
        this.serverPassF.addActionListener(this);
        this.portF = new JTextField(PreferenceManager.getClientPreferences().getLastServerPort() + "", 4);
        this.portF.addActionListener(this);
        IClientPreferences iClientPreferences = PreferenceManager.getClientPreferences();
        this.metaserver = iClientPreferences.getMetaServerName();
        this.metaserverL = new JLabel(Messages.getString("MegaMek.metaserverL"), 4);
        this.metaserverF = new JTextField(this.metaserver);
        this.metaserverL.setEnabled(this.register);
        this.metaserverF.setEnabled(this.register);
        int n = iClientPreferences.getGoalPlayers();
        this.goalL = new JLabel(Messages.getString("MegaMek.goalL"), 4);
        this.goalF = new JTextField(Integer.toString(n), 2);
        this.goalL.setEnabled(this.register);
        this.goalF.setEnabled(this.register);
        this.registerC = new JCheckBox(Messages.getString("MegaMek.registerC"));
        this.register = false;
        this.registerC.setSelected(this.register);
        this.registerC.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = false;
                if (itemEvent.getStateChange() == 1) {
                    bl = true;
                }
                HostDialog.this.metaserverL.setEnabled(bl);
                HostDialog.this.metaserverF.setEnabled(bl);
                HostDialog.this.goalL.setEnabled(bl);
                HostDialog.this.goalF.setEnabled(bl);
            }
        });
        this.okayB = new JButton(Messages.getString("Okay"));
        this.okayB.setActionCommand("done");
        this.okayB.addActionListener(this);
        this.okayB.setSize(80, 24);
        this.cancelB = new JButton(Messages.getString("Cancel"));
        this.cancelB.setActionCommand("cancel");
        this.cancelB.addActionListener(this);
        this.cancelB.setSize(80, 24);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.getContentPane().setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.yourNameL, gridBagConstraints);
        this.getContentPane().add(this.yourNameL);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.yourNameF, gridBagConstraints);
        this.getContentPane().add(this.yourNameF);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.serverPassL, gridBagConstraints);
        this.getContentPane().add(this.serverPassL);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.serverPassF, gridBagConstraints);
        this.getContentPane().add(this.serverPassF);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(this.portL, gridBagConstraints);
        this.getContentPane().add(this.portL);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.portF, gridBagConstraints);
        this.getContentPane().add(this.portF);
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.okayB, gridBagConstraints);
        this.getContentPane().add(this.okayB);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.cancelB, gridBagConstraints);
        this.getContentPane().add(this.cancelB);
        this.pack();
        this.setResizable(false);
        this.setLocation(jFrame.getLocation().x + jFrame.getSize().width / 2 - this.getSize().width / 2, jFrame.getLocation().y + jFrame.getSize().height / 2 - this.getSize().height / 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!"cancel".equals(actionEvent.getActionCommand())) {
            try {
                this.playerName = this.yourNameF.getText();
                this.serverPass = this.serverPassF.getText();
                this.register = this.registerC.isSelected();
                this.metaserver = this.metaserverF.getText();
                this.port = Integer.parseInt(this.portF.getText());
                this.goalPlayers = Integer.parseInt(this.goalF.getText());
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println(numberFormatException.getMessage());
                this.port = 2346;
                this.goalPlayers = 2;
            }
            PreferenceManager.getClientPreferences().setLastPlayerName(this.playerName);
            PreferenceManager.getClientPreferences().setLastServerPass(this.serverPass);
            PreferenceManager.getClientPreferences().setLastServerPort(this.port);
            PreferenceManager.getClientPreferences().setValue("megamek.megamek.metaservername", this.metaserver);
            PreferenceManager.getClientPreferences().setValue("megamek.megamek.goalplayers", Integer.toString(this.goalPlayers));
        }
        this.setVisible(false);
    }
}

