/*  MaitreTarot.
 *  (C) 2002 Philippe Brochard <hocwp@free.fr>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef MT_NCURSES_CLIENT_CARD_H
#define MT_NCURSES_CLIENT_CARD_H

#include <glib.h>
#include "defs.h"


/* card string name and color */
extern gchar card_str[NUMBER_OF_CARD][4];
extern gint card_color[NUMBER_OF_CARD];

extern gint card_sort[NUMBER_OF_CARD];


extern void init_card (void);

extern void draw_card_game (int line, int col);

extern void draw_hand_card (int line, int col, gint * card, gint card_sel);
extern void draw_chien_card (int line, int col, gint * card, gint card_sel);

extern void draw_card (int line, int col, gint card);

extern void sort_card (gint * card, gint nb_card);

#endif /* MT_NCURSES_CLIENT_CARD_H */
