dnl
dnl AM_LIB_MT_CLIENT(major,minor,micro,glib_inc_path,glib_lib_path)
dnl
AC_DEFUN([AM_LIB_MT_CLIENT],
[AC_CHECK_HEADERS(stdio.h stdlib.h sys/socket.h sys/types.h unistd.h netdb.h string.h netinet/in.h)
 AC_CHECK_FUNCS(alarm)
 LIBMT_LIBS=" -lmt_client "
 AC_ARG_WITH(libmt_client, \
  --with-libmt_client   path to libmt_client libraries,
      [ 
      	LIBMT_CFLAGS="-I${withval}/include"
      	LIBMT_LIBS="-L${withval}/lib -lmt_client"
	 ],[ 
      	LIBMT_CFLAGS="-I/usr/local/include -I/usr/include"
      	LIBMT_LIBS="-L/usr/local/lib -L/usr/lib -lmt_client"
	 ])
 ac_save_CPPFLAGS="$CPPFLAGS"
 ac_save_CFLAGS="$CFLAGS"
 ac_save_LIBS="$LIBS"
 CFLAGS="$CFLAGS $LIBMT_CFLAGS $4"
 CPPFLAGS="$CPPFLAGS $LIBMT_CFLAGS $4"
 LIBS="$LIBS $LIBMT_LIBS $5"
 AC_MSG_CHECKING([for mt_client.h])
 AC_TRY_CPP([#include <mt_client.h>],[
   AC_MSG_RESULT(yes)
   AC_CACHE_CHECK([for libmt_client], am_cv_lib_mt_client,
    [
    AC_TRY_RUN(
changequote(<<, >>)dnl
<</* Test program from Yves Mettier (ymettier@libertysurf.fr).  */

#include <mt_client.h>

int
main ()
{
  if (libmt_client_check_version ($1, $2, $3))
    exit (0);
  exit (1);
}
>>,
changequote([, ])
	     am_cv_lib_mt_client=yes, am_cv_lib_mt_client=no,
	     am_cv_lib_mt_client=no)
    ])],
    [
      am_cv_lib_mt_client=no
      AC_MSG_RESULT(no)
      AC_MSG_ERROR([Could not find mt_client.h. This file comes with libmt_client])
    ]
  )
  if test "x${am_cv_lib_mt_client}" = "xno"; then
       CFLAGS="$ac_save_CFLAGS"
       LIBS="$ac_save_LIBS"
       AC_MSG_ERROR([Could not find libmt_client])
  fi
  CPPFLAGS="$ac_save_CPPFLAGS"
  PKG_CHECK_MODULES(GLIB, glib-2.0 >= 1.3.1 gthread-2.0 >= 2.0 libxml-2.0 >= 2.0)
])
