/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*

  The default resource factory implementation. This resource factory
  produces nsIRDFResource objects for any URI prefix that is not
  covered by some other factory.

 */

#include "nsRDFResource.h"

nsresult NS_NewDefaultResource(nsIRDFResource** aResult) {
  NS_PRECONDITION(aResult != nullptr, "null ptr");
  if (!aResult) return NS_ERROR_NULL_POINTER;

  nsRDFResource* resource = new nsRDFResource();
  if (!resource) return NS_ERROR_OUT_OF_MEMORY;

  NS_ADDREF(resource);
  *aResult = resource;
  return NS_OK;
}
