/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.datastructures;

import com.sun.electric.tool.util.concurrent.datastructures.IStructure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CircularArray<T>
extends IStructure<T> {
    private int logCapacity;
    private T[] currentElements;

    public CircularArray(int logCapacity) {
        this.logCapacity = logCapacity;
        this.currentElements = new Object[1 << logCapacity];
    }

    public int getCapacity() {
        return 1 << this.logCapacity;
    }

    @Override
    public T get(int i) {
        return this.currentElements[i % this.getCapacity()];
    }

    @Override
    @Deprecated
    public void add(T item) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(T item, int i) {
        this.currentElements[i % this.getCapacity()] = item;
    }

    public CircularArray<T> resize(int bottom, int top) {
        CircularArray<T> newArray = new CircularArray<T>(this.logCapacity + 1);
        for (int i = top; i < bottom; ++i) {
            newArray.add(this.get(i), i);
        }
        return newArray;
    }

    @Override
    @Deprecated
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public T remove() {
        throw new UnsupportedOperationException();
    }
}

