/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.placement.genetic1;

import com.sun.electric.tool.placement.genetic1.Chromosome;
import com.sun.electric.tool.placement.genetic1.GenePlacement;
import com.sun.electric.tool.placement.genetic1.Metric;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Population {
    public List<Chromosome> chromosomes;
    Random randomGenerator;

    public Random getRandomGenerator() {
        return this.randomGenerator;
    }

    public void setRandomGenerator(Random randomGenerator) {
        this.randomGenerator = randomGenerator;
    }

    public Population(int size2) {
        this.chromosomes = new ArrayList<Chromosome>(size2);
    }

    public double getBest_fitness() {
        double best_fitness = Double.MAX_VALUE;
        for (Chromosome c : this.chromosomes) {
            assert (c.fitness > 0.0);
            if (!(c.fitness < best_fitness)) continue;
            best_fitness = c.fitness;
        }
        return best_fitness;
    }

    public void evaluate(Metric metric, GenePlacement placement) {
        for (Chromosome c : this.chromosomes) {
            assert (c.altered || c.fitness > 0.0);
            placement.placeChromosome(c);
        }
        metric.evaluate(this.chromosomes);
    }
}

