/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.gates.DrcRing;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public class DrcRings {
    public static void addDrcRings(Cell gallery, Filter filter) {
        if (filter == null) {
            filter = new Filter();
        }
        Library lib = gallery.getLibrary();
        StdCellParams stdCell = new StdCellParams(lib);
        ArrayList gates = new ArrayList();
        Iterator it = gallery.getNodes();
        while (it.hasNext()) {
            gates.add(it.next());
        }
        for (int i = 0; i < gates.size(); ++i) {
            NodeInst ni = (NodeInst)gates.get(i);
            if (filter.skip(ni) || ni.getProto() instanceof PrimitiveNode) continue;
            Rectangle2D cellBounds = LayoutLib.getBounds(ni);
            double ringW = cellBounds.getWidth() + 3.0;
            double ringH = cellBounds.getHeight() + 3.0;
            Cell ringProto = DrcRing.makePart(ringW, ringH, stdCell);
            NodeInst ringInst = LayoutLib.newNodeInst(ringProto, 0.0, 0.0, 0.0, 0.0, 0.0, gallery);
            Rectangle2D ringBounds = LayoutLib.getBounds(ringInst);
            LayoutLib.modNodeInst(ringInst, cellBounds.getCenterX() - ringBounds.getCenterX(), cellBounds.getCenterY() - ringBounds.getCenterY(), 0.0, 0.0, false, false, 0.0);
        }
    }

    public static class Filter {
        public boolean skip(NodeInst ni) {
            return false;
        }
    }
}

