/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xwt.ui.ExceptionHandle;
import org.eclipse.xwt.ui.XWTUIPlugin;
import org.eclipse.xwt.ui.jdt.ProjectHelper;

public class NewUIElementWizardPage
extends NewClassWizardPage {
    protected String superClass;
    protected IResource guiResource;

    public NewUIElementWizardPage() {
        this.setTitle("New Wizard Creation");
        this.setDescription("This wizard creates a *.xwt file with java host class.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.createSeparator(composite, nColumns);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_class_wizard_page_context");
    }

    public boolean isCreateConstructors() {
        return true;
    }

    public void validateDataContext() {
        String newMessage = "Invalid Java Type for initializing DataContext.";
        String errorMessage = this.getErrorMessage();
        if (newMessage.equals(errorMessage)) {
            this.setErrorMessage(null);
        } else {
            this.setErrorMessage(errorMessage);
        }
    }

    protected void initTypePage(IJavaElement elem) {
        super.initTypePage(elem);
        this.setSuperClass(this.getSuperClassName(), false);
    }

    protected String getSuperClassName() {
        return Composite.class.getName();
    }

    public int getModifiers() {
        return this.F_PUBLIC;
    }

    public List getSuperInterfaces() {
        return Collections.EMPTY_LIST;
    }

    public boolean isCreateMain() {
        return false;
    }

    protected InputStream getContentStream() {
        IType type = this.getCreatedType();
        String hostClassName = type.getFullyQualifiedName();
        ByteArrayOutputStream arrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(arrayOutputStream);
        printStream.println("<Composite xmlns=\"http://www.eclipse.org/xwt/presentation\"");
        printStream.println("\t xmlns:x=\"http://www.eclipse.org/xwt\"");
        String packageName = type.getPackageFragment().getElementName();
        if (packageName != null) {
            printStream.println("\t xmlns:c=\"clr-namespace:" + packageName + "\"");
        }
        printStream.println("\t xmlns:j=\"clr-namespace:java.lang\"");
        printStream.println("\t x:Class=\"" + hostClassName + "\">");
        printStream.println("\t <Composite.layout>");
        printStream.println("\t\t <GridLayout  numColumns=\"4\" />");
        printStream.println("\t </Composite.layout>");
        printStream.println("</Composite>");
        try {
            byte[] content = arrayOutputStream.toByteArray();
            printStream.close();
            arrayOutputStream.close();
            return new ByteArrayInputStream(content);
        }
        catch (Exception e) {
            XWTUIPlugin.log(e);
            ExceptionHandle.handle(e, "save failed in the file: " + this.getModifiedResource().getLocation());
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        ProjectHelper.checkDependenceJars(this.getJavaProject());
        super.createType(monitor);
        IResource resource = this.getModifiedResource();
        IPath resourcePath = resource.getProjectRelativePath().removeFileExtension();
        resourcePath = resourcePath.addFileExtension("xwt");
        try {
            IFile file = resource.getProject().getFile(resourcePath);
            file.create(this.getContentStream(), 3, monitor);
            this.guiResource = file;
        }
        catch (Exception e) {
            e.printStackTrace();
            ExceptionHandle.handle(e, "save failed in the file: " + this.getModifiedResource().getLocation());
        }
    }

    public String getTypeName() {
        String typeName = super.getTypeName();
        if (typeName == null || typeName.equals("")) {
            return typeName;
        }
        return String.valueOf(Character.toUpperCase(typeName.charAt(0))) + typeName.substring(1);
    }

    public boolean isCreateInherited() {
        return true;
    }

    public IResource getGuiResource() {
        return this.guiResource;
    }
}

