/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.ui.utils;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.xwt.ui.utils.DependencyBuilder;
import org.eclipse.xwt.ui.utils.LibraryBuilder;

public class ProjectUtil {
    static String[] WORKBENCH_BUNDLES = new String[]{"org.eclipse.e4.ui.services", "org.eclipse.e4.ui.workbench", "org.eclipse.e4.core.di", "org.eclipse.e4.core.di.extensions", "org.eclipse.e4.core.contexts", "org.eclipse.e4.core.services", "org.eclipse.e4.ui.workbench.swt", "org.eclipse.e4.ui.css.core", "org.w3c.css.sac", "org.eclipse.e4.core.commands", "org.eclipse.e4.ui.bindings", "org.eclipse.xwt.css", "org.eclipse.xwt.ui.workbench", "javax.inject"};
    static String[] XWT_CORE_BUNDLES = new String[]{"org.eclipse.xwt", "org.eclipse.jface.databinding", "org.eclipse.swt", "org.eclipse.jface", "org.eclipse.core.databinding", "com.ibm.icu"};
    static String[] XWT_DATABINING_BUNDLES = new String[]{"org.eclipse.core.databinding.beans", "org.eclipse.core.databinding.property"};
    static String[] XWT_EMF_BUNDLES = new String[]{"org.eclipse.xwt.emf", "org.eclipse.emf.databinding", "org.eclipse.core.databinding.property"};

    public static void updateXWTCoreDependencies(IProject project) {
        ProjectUtil.addDependencies(project, new String[][]{XWT_CORE_BUNDLES});
    }

    public static void updateXWTDataBindingDependencies(IProject project) {
        ProjectUtil.addDependencies(project, XWT_CORE_BUNDLES, XWT_DATABINING_BUNDLES);
    }

    public static void updateXWTWorkbenchDependencies(IProject project) {
        ProjectUtil.addDependencies(project, XWT_CORE_BUNDLES, XWT_DATABINING_BUNDLES, WORKBENCH_BUNDLES);
    }

    public static void updateXWTEMFDependencies(IProject project) {
        ProjectUtil.addDependencies(project, XWT_CORE_BUNDLES, XWT_EMF_BUNDLES);
    }

    public static IStatus addDependencies(IProject project, String[] ... pluginIds) {
        IPluginModelBase[] dependencies = ProjectUtil.getDependencies(project, true, pluginIds);
        return new DependencyBuilder(project, dependencies).build();
    }

    public static IStatus addDependencies(IProject project, IPluginModelBase[] pluginImports) {
        return new DependencyBuilder(project, pluginImports).build();
    }

    public static IStatus removeDependencies(IProject project, String[] ... pluginIds) {
        IPluginModelBase[] dependencies = ProjectUtil.getDependencies(project, false, pluginIds);
        return new DependencyBuilder(project, dependencies).unbuild();
    }

    public static IStatus removeDependencies(IProject project, IPluginModelBase[] pluginImports) {
        return new DependencyBuilder(project, pluginImports).unbuild();
    }

    public static IStatus addLibraries(IProject project, String[] jarPaths) {
        String[] libraries = ProjectUtil.getLibraries(project, jarPaths, true);
        return new LibraryBuilder(project, libraries).build();
    }

    public static IStatus removeLibraries(IProject project, String[] jarPaths) {
        String[] libraries = ProjectUtil.getLibraries(project, jarPaths, false);
        return new LibraryBuilder(project, libraries).unbuild();
    }

    public static IPluginModelBase[] getDependencies(IProject project, boolean ignoreExists, String[] ... pluginIds) {
        int n;
        IPluginBase pluginBase;
        if (pluginIds == null || pluginIds.length == 0) {
            return new IPluginModelBase[0];
        }
        ArrayList<String> existingImports = new ArrayList<String>();
        if (ignoreExists && (pluginBase = ProjectUtil.getPluginBase(project)) != null) {
            IPluginImport[] imports;
            IPluginImport[] iPluginImportArray = imports = pluginBase.getImports();
            int n2 = imports.length;
            n = 0;
            while (n < n2) {
                IPluginImport pluginImport = iPluginImportArray[n];
                existingImports.add(pluginImport.getId());
                ++n;
            }
        }
        ArrayList<IPluginModelBase> models = new ArrayList<IPluginModelBase>();
        String[][] stringArray = pluginIds;
        n = pluginIds.length;
        int n3 = 0;
        while (n3 < n) {
            String[] ids;
            String[] stringArray2 = ids = stringArray[n3];
            int n4 = ids.length;
            int n5 = 0;
            while (n5 < n4) {
                IPluginModelBase model;
                String pluginId = stringArray2[n5];
                if (!(ignoreExists && existingImports.contains(pluginId) || (model = PluginRegistry.findModel((String)pluginId)) == null)) {
                    models.add(model);
                }
                ++n5;
            }
            ++n3;
        }
        return models.toArray(new IPluginModelBase[models.size()]);
    }

    public static IPluginBase getPluginBase(IProject project) {
        if (project == null || !project.exists()) {
            return null;
        }
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        if (model != null) {
            return model.getPluginBase(true);
        }
        return null;
    }

    public static String[] getLibraries(IProject project, String[] jarPaths, boolean ignoreExists) {
        int n;
        IPluginBase pluginBase;
        if (jarPaths == null || jarPaths.length == 0) {
            return new String[0];
        }
        ArrayList<String> existingLibraries = new ArrayList<String>();
        if (ignoreExists && (pluginBase = ProjectUtil.getPluginBase(project)) != null) {
            IPluginLibrary[] libraries;
            IPluginLibrary[] iPluginLibraryArray = libraries = pluginBase.getLibraries();
            int n2 = libraries.length;
            n = 0;
            while (n < n2) {
                IPluginLibrary pluginLibrary = iPluginLibraryArray[n];
                existingLibraries.add(pluginLibrary.getName());
                ++n;
            }
        }
        ArrayList<String> libraries = new ArrayList<String>();
        String[] stringArray = jarPaths;
        n = jarPaths.length;
        int n3 = 0;
        while (n3 < n) {
            String path = stringArray[n3];
            if (!ignoreExists || !existingLibraries.contains(path)) {
                libraries.add(path);
            }
            ++n3;
        }
        return libraries.toArray(new String[libraries.size()]);
    }
}

