/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.editor;

import java.lang.reflect.Field;
import java.util.EventObject;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.gef.ui.views.palette.PalettePage;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheetPage;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.JobSafeStructuredDocument;
import org.eclipse.wst.sse.core.internal.undo.IStructuredTextUndoManager;
import org.eclipse.wst.sse.core.internal.undo.StructuredTextUndoManager;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.xwt.tools.ui.designer.core.DesignerPlugin;
import org.eclipse.xwt.tools.ui.designer.core.component.CustomSashForm;
import org.eclipse.xwt.tools.ui.designer.core.editor.ActionGroup;
import org.eclipse.xwt.tools.ui.designer.core.editor.DesignerMenuProvider;
import org.eclipse.xwt.tools.ui.designer.core.editor.EditDomain;
import org.eclipse.xwt.tools.ui.designer.core.editor.ISelectionSynchronizer;
import org.eclipse.xwt.tools.ui.designer.core.editor.IVisualRenderer;
import org.eclipse.xwt.tools.ui.designer.core.editor.LoadingFigureController;
import org.eclipse.xwt.tools.ui.designer.core.editor.Refresher;
import org.eclipse.xwt.tools.ui.designer.core.editor.SelectionSynchronizer;
import org.eclipse.xwt.tools.ui.designer.core.editor.SourceSelectionProvider;
import org.eclipse.xwt.tools.ui.designer.core.editor.commandstack.CombinedCommandStack;
import org.eclipse.xwt.tools.ui.designer.core.editor.dnd.DropContext;
import org.eclipse.xwt.tools.ui.designer.core.editor.dnd.DropTargetAdapter;
import org.eclipse.xwt.tools.ui.designer.core.editor.dnd.GraphicalViewerDropCreationListener;
import org.eclipse.xwt.tools.ui.designer.core.editor.dnd.palette.PaletteDropAdapter;
import org.eclipse.xwt.tools.ui.designer.core.editor.outline.DesignerOutlinePage;
import org.eclipse.xwt.tools.ui.designer.core.editor.text.StructuredTextHelper;
import org.eclipse.xwt.tools.ui.designer.core.model.IModelBuilder;
import org.eclipse.xwt.tools.ui.designer.core.model.ModelChangeListener;
import org.eclipse.xwt.tools.ui.designer.core.parts.RefreshContext;
import org.eclipse.xwt.tools.ui.designer.core.parts.root.DesignerRootEditPart;
import org.eclipse.xwt.tools.ui.designer.core.problems.ConfigurableProblemHandler;
import org.eclipse.xwt.tools.ui.designer.core.problems.ProblemHandler;
import org.eclipse.xwt.tools.ui.designer.core.util.DisplayUtil;
import org.eclipse.xwt.tools.ui.palette.page.ContributePalettePage;
import org.eclipse.xwt.tools.ui.palette.page.CustomPalettePage;

public abstract class Designer
extends MultiPageEditorPart
implements ISelectionChangedListener,
CommandStackListener {
    public static final String DESIGNER_INPUT = "DESIGNER INPUT";
    public static final String DESIGNER_TEXT_EDITOR = "DESIGNER TEXT EDITOR";
    public static final String DEFAULT_DESIGNER_CONTEXT_MENU_ID = "#DesignerContext";
    protected CustomSashForm pageContainer;
    private CustomPalettePage palettePage;
    private IPropertySheetPage propertyPage;
    private DesignerOutlinePage outlinePage;
    private ProblemHandler problemHandler;
    private GraphicalViewer graphicalViewer;
    private EditDomain editDomain;
    private ISelectionSynchronizer selectionSynchronizer;
    private ActionRegistry actionRegistry;
    private ActionGroup actionGroup;
    private StructuredTextEditor fTextEditor;
    private IPropertyListener fPropertyListener;
    private DropTargetAdapter dropListener;
    private EObject documentRoot;
    private IVisualRenderer visualsRender;
    private CombinedCommandStack commandStack = new CombinedCommandStack();
    private IModelBuilder modelBuilder;
    private boolean installed = false;
    private ModelChangeListener modelBuilderListener;
    protected Display display;
    private LoadingFigureController loadingFigureController;
    private EditPartFactory editPartFactory;
    private KeyHandler fSharedKeyHandler;
    private Refresher refresher;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        site.setSelectionProvider(null);
        this.display = site.getShell().getDisplay();
        this.loadingFigureController = new LoadingFigureController();
        this.editDomain = new EditDomain((IEditorPart)this);
        this.editDomain.setCommandStack(this.commandStack.getCommandStack4GEF());
        this.setPartName(input.getName());
        this.getEditDomain().setData(DESIGNER_INPUT, input);
        this.getCommandStack().getCommandStack4GEF().addCommandStackListener((CommandStackListener)this);
        this.createActions();
        this.configureActions();
        this.refresher = new Refresher(this.display);
    }

    public Refresher getRefresher() {
        return this.refresher;
    }

    protected void configureActions() {
        this.actionGroup.updateActions(1);
        this.actionGroup.updateActions(2);
        if (this.graphicalViewer != null) {
            Iterator actions = this.getActionRegistry().getActions();
            while (actions.hasNext()) {
                Object object = actions.next();
                if (!(object instanceof SelectionAction)) continue;
                ((SelectionAction)object).setSelectionProvider((ISelectionProvider)this.graphicalViewer);
            }
        }
    }

    public void setFocus() {
        if (this.graphicalViewer != null && this.graphicalViewer.getControl() != null) {
            this.graphicalViewer.getControl().setFocus();
        }
        super.setFocus();
    }

    private void dispatchModelEvent(final Notification event) {
        if (event.isTouch() || !this.installed) {
            return;
        }
        if (this.display != null && this.display.getThread() == Thread.currentThread()) {
            this.performModelChanged(event);
        } else if (this.display != null) {
            DisplayUtil.asyncExec(this.display, new Runnable(){

                @Override
                public void run() {
                    Designer.this.performModelChanged(event);
                }
            });
        }
    }

    protected void performModelChanged(Notification event) {
        IVisualRenderer.Result result;
        if (this.visualsRender == null || event.isTouch()) {
            return;
        }
        try {
            result = this.getVisualsRender().refreshVisuals(event);
        }
        catch (RuntimeException e) {
            return;
        }
        if (result == null || !result.refreshed) {
            return;
        }
        RootEditPart toRefresh = null;
        Object notifier = result.visuals;
        if (notifier == null) {
            toRefresh = this.getGraphicalViewer().getRootEditPart();
        } else {
            toRefresh = this.getEditPart(notifier);
            if (toRefresh == null) {
                while (notifier != null && notifier instanceof EObject) {
                    EObject parentNode = ((EObject)notifier).eContainer();
                    if (this.getEditPart(parentNode) != null) {
                        toRefresh = this.getEditPart(parentNode).getParent();
                    }
                    notifier = parentNode;
                }
            }
        }
        if (toRefresh == null) {
            return;
        }
        this.refresher.refreshInJob((EditPart)toRefresh);
        this.getOutlinePage().refresh(toRefresh);
        if (toRefresh.isSelectable()) {
            this.graphicalViewer.setSelection((ISelection)new StructuredSelection((Object)toRefresh));
        }
    }

    public void refresh(EditPart editPart, RefreshContext context) {
        this.refresher.refresh(editPart, context);
        this.getOutlinePage().refresh((Object)editPart);
    }

    public EditPart getEditPart(Object model) {
        return (EditPart)this.graphicalViewer.getEditPartRegistry().get(model);
    }

    private void setDocumentRoot(EObject document) {
        this.documentRoot = document;
    }

    public EObject getDocumentRoot() {
        return this.documentRoot;
    }

    private void tryToLoadModels() {
        this.loadingFigureController.showLoadingFigure(true);
        this.loadingFigureController.startListener(this.getGraphicalViewer());
        UIJob setupJob = new UIJob("Setup"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (Designer.this.modelBuilder.doLoad((IEditorPart)Designer.this, monitor)) {
                    Designer.this.setDocumentRoot(Designer.this.modelBuilder.getDiagram());
                }
                if (!Designer.this.isDisposed()) {
                    try {
                        Designer.this.setupGraphicalViewer();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        setupJob.setDisplay(this.display);
        setupJob.setPriority(20);
        IModelBuilder modelBuilder = this.getModelBuilder();
        if (this.getDocument() != null && modelBuilder != null) {
            setupJob.schedule();
        }
    }

    protected void runWithDialog(IRunnableWithProgress runnable) {
        try {
            ProgressMonitorDialog d = new ProgressMonitorDialog(this.getSite().getShell());
            d.run(true, false, runnable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void setupGraphicalViewer() {
        IVisualRenderer vr = this.getVisualsRender();
        if (vr != null) {
            vr.createVisuals();
            this.getEditDomain().setViewerData(this.getGraphicalViewer(), "org.eclipse.e4.tools.ui.designer.editor.VisualsRender", vr);
        }
        this.setContent(this.getDocumentRoot());
        this.loadingFigureController.showLoadingFigure(false);
        this.installed = true;
    }

    protected void setContent(EObject diagram) {
        DesignerOutlinePage outlinePage;
        GraphicalViewer graphicalViewer = this.getGraphicalViewer();
        if (graphicalViewer != null) {
            EditPart diagramEp = this.getDiagramEditPart();
            graphicalViewer.setContents(diagramEp);
            if (diagramEp != null) {
                this.refresher.refreshAsynchronous(diagramEp);
            }
        }
        if ((outlinePage = this.getOutlinePage()) != null) {
            outlinePage.setContents(diagram);
        }
    }

    public IVisualRenderer getVisualsRender() {
        if (this.visualsRender == null) {
            this.visualsRender = this.createVisualsRender();
        }
        return this.visualsRender;
    }

    private EditPart getDiagramEditPart() {
        return this.getEditPartFactory().createEditPart((EditPart)this.getGraphicalViewer().getRootEditPart(), (Object)this.getDocumentRoot());
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected synchronized boolean isDisposed() {
        return this.editDomain == null;
    }

    public IFile getFile() {
        IEditorInput editorInput = this.getEditorInput();
        return (IFile)editorInput.getAdapter(IFile.class);
    }

    public IModelBuilder getModelBuilder() {
        if (this.modelBuilder == null) {
            this.modelBuilder = this.createModelBuilder();
        }
        if (this.modelBuilderListener == null) {
            this.modelBuilderListener = new ModelChangeListener(){

                public void notifyChanged(Notification event) {
                    Designer.this.dispatchModelEvent(event);
                }
            };
        }
        if (!this.modelBuilder.hasListener(this.modelBuilderListener)) {
            this.modelBuilder.addModelListener(this.modelBuilderListener);
        }
        return this.modelBuilder;
    }

    protected abstract IModelBuilder createModelBuilder();

    protected void createActions() {
        if (this.actionGroup == null) {
            this.actionGroup = new ActionGroup((IEditorPart)this);
        }
        this.actionGroup.createActions();
    }

    public ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    protected Composite createPageContainer(Composite parent) {
        ViewForm diagramPart = new ViewForm(parent, 0x800000);
        ToolBar toolBar = this.createToolBar((Composite)diagramPart);
        if (toolBar != null && !toolBar.isDisposed()) {
            diagramPart.setTopLeft((Control)toolBar);
        }
        this.pageContainer = new CustomSashForm((Composite)diagramPart, 512);
        this.pageContainer.setBackgroundMode(1);
        this.createGraphicalViewer((Composite)this.pageContainer);
        diagramPart.setContent((Control)this.pageContainer);
        return this.pageContainer;
    }

    protected boolean isEditable() {
        return true;
    }

    private void createGraphicalViewer(Composite parent) {
        this.graphicalViewer = new ScrollingGraphicalViewer();
        this.graphicalViewer.createControl(parent);
        this.graphicalViewer.getControl().setBackground(ColorConstants.listBackground);
        this.configureGraphicalViewer();
    }

    protected void configureGraphicalViewer() {
        this.graphicalViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.editDomain.addViewer((EditPartViewer)this.graphicalViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.graphicalViewer);
        this.getSelectionSynchronizer().addProvider((ISelectionProvider)this.graphicalViewer);
        this.graphicalViewer.setEditPartFactory(this.getEditPartFactory());
        ContextMenuProvider menuProvider = this.createMenuProvider((EditPartViewer)this.graphicalViewer, this.getActionRegistry());
        if (menuProvider != null) {
            this.graphicalViewer.setContextMenu((MenuManager)menuProvider);
            menuProvider.setRemoveAllWhenShown(true);
            this.getSite().registerContextMenu(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".contextMenu", (MenuManager)menuProvider, (ISelectionProvider)this.graphicalViewer);
        }
        DesignerRootEditPart rootEditPart = new DesignerRootEditPart();
        this.graphicalViewer.setRootEditPart((RootEditPart)rootEditPart);
        this.graphicalViewer.setKeyHandler(new GraphicalViewerKeyHandler(this.graphicalViewer).setParent(this.getCommonKeyHandler()));
        this.setupGraphicalViewerDropCreation(this.graphicalViewer);
        Iterator actions = this.getActionRegistry().getActions();
        while (actions.hasNext()) {
            Object object = actions.next();
            if (!(object instanceof SelectionAction)) continue;
            ((SelectionAction)object).setSelectionProvider((ISelectionProvider)this.graphicalViewer);
        }
    }

    protected void setupGraphicalViewerDropCreation(GraphicalViewer viewer) {
        viewer.addDropTargetListener((TransferDropTargetListener)new GraphicalViewerDropCreationListener((EditPartViewer)viewer));
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.fSharedKeyHandler == null) {
            this.fSharedKeyHandler = new KeyHandler();
            this.fSharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.fSharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.fSharedKeyHandler;
    }

    protected ContextMenuProvider createMenuProvider(EditPartViewer viewer, ActionRegistry actionRegistry) {
        return new DesignerMenuProvider(viewer, actionRegistry);
    }

    public ISelectionSynchronizer getSelectionSynchronizer() {
        if (this.selectionSynchronizer == null) {
            this.selectionSynchronizer = this.createSelectionSynchronizer();
        }
        return this.selectionSynchronizer;
    }

    protected ISelectionSynchronizer createSelectionSynchronizer() {
        return new SelectionSynchronizer();
    }

    protected ToolBar createToolBar(Composite parent) {
        return null;
    }

    protected void createPages() {
        this.createSourcePage();
        this.createExternalPages();
        this.updateContainer();
    }

    private void updateContainer() {
        Composite container = this.getContainer();
        if (container == null || !(container instanceof CTabFolder)) {
            return;
        }
        CTabFolder tabFolder = (CTabFolder)container;
        tabFolder.setTabPosition(128);
        tabFolder.setSimple(false);
        ToolBar toolBar = new ToolBar((Composite)tabFolder, 8519744);
        this.configureContainerToolBar(toolBar);
        tabFolder.setTopRight((Control)toolBar);
        tabFolder.setTabHeight(Math.max(toolBar.computeSize((int)-1, (int)-1).y, tabFolder.getTabHeight()));
    }

    protected void configureContainerToolBar(ToolBar toolBar) {
    }

    protected void createExternalPages() {
    }

    private void createSourcePage() {
        this.fTextEditor = new StructuredTextEditor();
        final StructuredTextUndoManager undoManager = new StructuredTextUndoManager((org.eclipse.emf.common.command.CommandStack)this.commandStack);
        TextFileDocumentProvider provider = new TextFileDocumentProvider(){

            public IDocument getDocument(Object element) {
                JobSafeStructuredDocument document = (JobSafeStructuredDocument)super.getDocument(element);
                if (document != null) {
                    try {
                        Field fUndoManager = BasicStructuredDocument.class.getDeclaredField("fUndoManager");
                        fUndoManager.setAccessible(true);
                        Object object = fUndoManager.get(document);
                        if (object != null && object != undoManager) {
                            fUndoManager.set(document, null);
                            document.setUndoManager((IStructuredTextUndoManager)undoManager);
                        } else if (object == null) {
                            document.setUndoManager((IStructuredTextUndoManager)undoManager);
                        }
                    }
                    catch (Exception e) {
                        DesignerPlugin.logError(e);
                    }
                }
                return document;
            }
        };
        this.fTextEditor.initializeDocumentProvider((IDocumentProvider)provider);
        this.fTextEditor.setEditorPart((IEditorPart)this);
        if (this.fPropertyListener == null) {
            this.fPropertyListener = new PropertyListener();
        }
        this.fTextEditor.addPropertyListener(this.fPropertyListener);
        try {
            int fSourcePageIndex = this.addPage((IEditorPart)this.fTextEditor, this.getEditorInput());
            this.setPageText(fSourcePageIndex, "Source");
            this.firePropertyChange(1);
            this.tryToLoadModels();
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        SourceSelectionProvider selectionProvider = new SourceSelectionProvider(this, this.fTextEditor);
        this.getSelectionSynchronizer().addProvider(selectionProvider);
        this.fTextEditor.setAction(ITextEditorActionConstants.DELETE, null);
        if (this.pageContainer != null) {
            this.pageContainer.setWeights(new int[]{1, 1});
        }
        this.configureTextEditor();
    }

    protected IEditorSite createSite(IEditorPart editor) {
        Object site = null;
        site = editor == this.fTextEditor ? new MultiPageEditorSite(this, editor){

            public String getId() {
                return String.valueOf(ContentTypeIdForXML.ContentTypeID_XML) + ".source";
            }
        } : super.createSite(editor);
        return site;
    }

    protected void configureTextEditor() {
        StyledText styledText;
        if (this.getPalettePage() == null) {
            return;
        }
        if (this.dropListener == null) {
            this.dropListener = new DropTargetAdapter();
            DropContext dropContext = this.getDropContext();
            if (dropContext != null) {
                this.dropListener.addDropAdapter(new PaletteDropAdapter(this, dropContext));
            }
        }
        if ((styledText = this.getTextWidget()) == null || this.dropListener == null) {
            return;
        }
        DropTarget dropTarget = (DropTarget)styledText.getData("DropTarget");
        if (dropTarget != null) {
            dropTarget.removeDropListener((DropTargetListener)this.dropListener);
            dropTarget.dispose();
        }
        dropTarget = new DropTarget((Control)styledText, 3);
        dropTarget.setTransfer(new Transfer[]{this.getPalettePage().getPaletteTransfer()});
        dropTarget.addDropListener((DropTargetListener)this.dropListener);
        styledText.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StyledText styledText = (StyledText)e.widget;
                DropTarget dropTarget = (DropTarget)styledText.getData("DropTarget");
                if (dropTarget != null) {
                    dropTarget.removeDropListener((DropTargetListener)Designer.this.dropListener);
                }
            }
        });
        this.getProblemHandler().handle();
    }

    public void format() {
        StructuredTextViewer textViewer = this.getTextViewer();
        if (textViewer != null && textViewer.canDoOperation(23)) {
            textViewer.doOperation(23);
        } else if (this.getDocument() != null) {
            StructuredTextHelper.format(this.getDocument());
        }
    }

    public void formatWithCompound(Runnable runnable) {
        if (runnable == null) {
            this.format();
            return;
        }
        StructuredTextViewer textViewer = this.getTextViewer();
        if (textViewer == null) {
            runnable.run();
            return;
        }
        IRewriteTarget rewriteTarget = textViewer.getRewriteTarget();
        if (rewriteTarget != null) {
            rewriteTarget.beginCompoundChange();
        }
        runnable.run();
        this.format();
        if (rewriteTarget != null) {
            rewriteTarget.endCompoundChange();
        }
    }

    public StyledText getTextWidget() {
        if (this.getTextViewer() != null) {
            return this.getTextViewer().getTextWidget();
        }
        return null;
    }

    public StructuredTextViewer getTextViewer() {
        if (this.fTextEditor != null) {
            return this.fTextEditor.getTextViewer();
        }
        return null;
    }

    public IDocument getDocument() {
        IDocument document = null;
        if (this.fTextEditor != null) {
            IDocumentProvider documentProvider = this.fTextEditor.getDocumentProvider();
            IEditorInput editorInput = this.fTextEditor.getEditorInput();
            if (documentProvider == null || editorInput == null) {
                return null;
            }
            document = documentProvider.getDocument((Object)editorInput);
        }
        return document;
    }

    public void doSave(IProgressMonitor monitor) {
        this.fTextEditor.doSave(monitor);
        if (this.modelBuilder != null) {
            this.modelBuilder.doSave(monitor);
        }
    }

    public void doSaveAs() {
        this.fTextEditor.doSaveAs();
    }

    public void dispose() {
        this.getModelBuilder().removeModelListener(this.modelBuilderListener);
        this.getModelBuilder().dispose();
        this.getCommandStack().getCommandStack4GEF().removeCommandStackListener((CommandStackListener)this);
        this.getCommandStack().flush();
        this.getGraphicalViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        if (this.modelBuilder != null) {
            this.modelBuilder.dispose();
        }
        if (this.visualsRender != null) {
            this.visualsRender.dispose();
        }
        this.fSharedKeyHandler = null;
        this.getActionRegistry().dispose();
        this.getProblemHandler().clear();
        super.dispose();
    }

    public Object getAdapter(Class adapter) {
        if (ActionRegistry.class == adapter) {
            return this.getActionRegistry();
        }
        if (org.eclipse.gef.EditDomain.class.isAssignableFrom(adapter)) {
            return this.getEditDomain();
        }
        if (PalettePage.class.isAssignableFrom(adapter)) {
            return this.getPalettePage();
        }
        if (CommandStack.class == adapter) {
            return this.getCommandStack().getCommandStack4GEF();
        }
        if (GraphicalViewer.class == adapter) {
            return this.getGraphicalViewer();
        }
        if (adapter == IPropertySheetPage.class) {
            return this.getPropertySheetPage();
        }
        if (adapter == IContentOutlinePage.class) {
            return this.getOutlinePage();
        }
        if (adapter == ProblemHandler.class) {
            return this.getProblemHandler();
        }
        if (adapter == EditPart.class && this.getGraphicalViewer() != null) {
            return this.getGraphicalViewer().getRootEditPart();
        }
        if (adapter == IFigure.class && this.getGraphicalViewer() != null) {
            return ((GraphicalEditPart)this.getGraphicalViewer().getRootEditPart()).getFigure();
        }
        if (adapter == IProject.class) {
            return this.getProject();
        }
        if (adapter == IFile.class) {
            return this.getFile();
        }
        return super.getAdapter(adapter);
    }

    public ProblemHandler getProblemHandler() {
        if (this.problemHandler == null) {
            this.problemHandler = new ConfigurableProblemHandler(this);
        }
        return this.problemHandler;
    }

    protected DesignerOutlinePage getOutlinePage() {
        if (this.outlinePage == null) {
            this.outlinePage = this.createOutlinePage();
            if (this.outlinePage != null) {
                this.getSelectionSynchronizer().addProvider((ISelectionProvider)this.outlinePage.getTreeViewer());
            }
        }
        return this.outlinePage;
    }

    protected abstract DesignerOutlinePage createOutlinePage();

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertyPage == null || this.propertyPage.getControl() == null || this.propertyPage.getControl().isDisposed()) {
            this.propertyPage = this.createPropertyPage();
        }
        return this.propertyPage;
    }

    protected IPropertySheetPage createPropertyPage() {
        return new PropertySheetPage();
    }

    private CustomPalettePage getPalettePage() {
        if (this.palettePage == null) {
            this.palettePage = new ContributePalettePage((IEditorPart)this, (org.eclipse.gef.EditDomain)this.editDomain);
        }
        return this.palettePage;
    }

    public CombinedCommandStack getCommandStack() {
        return this.commandStack;
    }

    public EditDomain getEditDomain() {
        return this.editDomain;
    }

    public boolean isSaveAsAllowed() {
        return this.fTextEditor.isSaveAsAllowed();
    }

    protected EditPart convert(EditPartViewer viewer, EditPart part) {
        Object temp = viewer.getEditPartRegistry().get(part.getModel());
        EditPart newPart = null;
        if (temp != null) {
            newPart = (EditPart)temp;
        }
        return newPart;
    }

    public final void selectionChanged(SelectionChangedEvent event) {
        Object source = event.getSource();
        if (source == null) {
            return;
        }
        while (Display.getDefault().readAndDispatch()) {
        }
        IEditorPart activeEditor = this.getSite().getPage().getActiveEditor();
        if (((Object)((Object)this)).equals(activeEditor)) {
            this.performSelectionChanged(event);
        }
    }

    protected void performSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        DisplayUtil.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (Designer.this.actionGroup != null) {
                    Designer.this.actionGroup.updateActions(0);
                }
                ActionRegistry actionRegistry = Designer.this.getActionRegistry();
                Iterator actions = actionRegistry.getActions();
                while (actions.hasNext()) {
                    Object object = actions.next();
                    if (!(object instanceof SelectionAction)) continue;
                    ((SelectionAction)object).update();
                }
            }
        });
    }

    public void gotoDefinition(EObject node) {
        EditPart editPart = this.getEditPart(node);
        if (editPart != null) {
            this.graphicalViewer.setSelection((ISelection)new StructuredSelection((Object)editPart));
        }
    }

    public void commandStackChanged(EventObject event) {
        if (this.actionGroup != null) {
            this.actionGroup.updateActions(2);
        }
    }

    public StructuredTextEditor getTextEditor() {
        return this.fTextEditor;
    }

    void _firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    public IProject getProject() {
        return this.getFile().getProject();
    }

    public EditPartFactory getEditPartFactory() {
        if (this.editPartFactory == null) {
            this.editPartFactory = this.createEditPartFactory();
        }
        return this.editPartFactory;
    }

    protected abstract EditPartFactory createEditPartFactory();

    protected abstract IVisualRenderer createVisualsRender();

    protected abstract DropContext getDropContext();

    class PropertyListener
    implements IPropertyListener {
        PropertyListener() {
        }

        public void propertyChanged(Object source, int propId) {
            switch (propId) {
                case 257: 
                case 258: {
                    if (source != Designer.this.getTextEditor() || Designer.this.getTextEditor().getEditorInput() == Designer.this.getEditorInput()) break;
                    Designer.this.setInput(Designer.this.getTextEditor().getEditorInput());
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            Designer.this._firePropertyChange(1);
                        }
                    };
                    ((Control)Designer.this.getTextEditor().getAdapter(Control.class)).getDisplay().asyncExec(runnable);
                    break;
                }
                case 1: {
                    if (source != Designer.this.getTextEditor() || Designer.this.getTextEditor().getEditorInput() == Designer.this.getEditorInput()) break;
                    Designer.this.setInput(Designer.this.getTextEditor().getEditorInput());
                    break;
                }
                default: {
                    if (source != Designer.this.getTextEditor()) break;
                    Designer.this._firePropertyChange(propId);
                }
            }
        }
    }
}

