/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.sash;

import org.eclipse.gef.EditPart;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.internal.utils.LoggerManager;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.tools.ui.designer.commands.AddNewChildCommand;
import org.eclipse.xwt.tools.ui.designer.core.util.SashUtil;
import org.eclipse.xwt.tools.ui.designer.parts.SashEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.SashFormEditPart;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class AddSashFormChildCommands
extends AddNewChildCommand {
    public static final String WIEGHTS_ATTR = "weights";
    private EditPart host;
    private int[] oldWeights;
    private boolean hasWeightsAttribute = false;

    public AddSashFormChildCommands(EditPart parent, XamlNode child) {
        this(parent, child, -1);
    }

    public AddSashFormChildCommands(EditPart parent, XamlNode child, int index) {
        super((XamlNode)parent.getModel(), child, index);
        this.host = parent;
    }

    @Override
    public boolean canExecute() {
        String ns;
        boolean result;
        boolean bl = result = super.canExecute() && this.host instanceof SashFormEditPart;
        if (!result) {
            return false;
        }
        XamlNode child = this.getChild();
        String name = child.getName();
        IMetaclass metaclass = XWT.getMetaclass((String)name, (String)(ns = child.getNamespace()));
        return metaclass.getType() != Sash.class;
    }

    @Override
    public void execute() {
        XamlNode sashForm = (XamlNode)this.host.getModel();
        XamlAttribute attribute = sashForm.getAttribute(WIEGHTS_ATTR, "http://www.eclipse.org/xwt/presentation");
        SashFormEditPart sashFormEditPart = (SashFormEditPart)this.host;
        SashForm form = (SashForm)sashFormEditPart.getWidget();
        boolean bl = this.hasWeightsAttribute = attribute != null;
        if (!this.hasWeightsAttribute) {
            super.execute();
            return;
        }
        this.oldWeights = form.getWeights();
        int children = 0;
        for (Object child : sashFormEditPart.getChildren()) {
            if (child instanceof SashEditPart) continue;
            ++children;
        }
        if (children == 0) {
            try {
                super.execute();
            }
            catch (Exception e) {
                LoggerManager.log((Throwable)e);
            }
            return;
        }
        int[] weights = new int[children + 1];
        int sum = 0;
        if (this.oldWeights.length != 0) {
            int index;
            int i = 0;
            while (i < this.oldWeights.length) {
                weights[i] = this.oldWeights[i];
                sum += this.oldWeights[i];
                ++i;
            }
            if (children > this.oldWeights.length) {
                delta = sum / (children - this.oldWeights.length);
                int i2 = this.oldWeights.length;
                while (i2 < children - 1) {
                    weights[i2] = delta;
                    ++i2;
                }
                weights[children - 1] = sum - delta * (children - this.oldWeights.length);
            }
            if ((index = this.getIndex()) == -1) {
                index = children;
            }
            int part1 = weights[index] / 2;
            int part2 = weights[index] - part1;
            int i3 = children - 1;
            while (i3 > index) {
                weights[i3 + 1] = this.oldWeights[i3];
                --i3;
            }
            weights[index] = part1;
            weights[index + 1] = part2;
        } else {
            delta = 1000 / weights.length;
            int i = 0;
            while (i < weights.length - 1) {
                weights[i] = delta;
                ++i;
            }
            weights[weights.length - 1] = sum - delta * children;
        }
        try {
            super.execute();
            if (weights.length > 1) {
                String value = SashUtil.weightsValue((int[])weights);
                if (attribute == null) {
                    attribute = XamlFactory.eINSTANCE.createAttribute(WIEGHTS_ATTR, "http://www.eclipse.org/xwt/presentation");
                    sashForm.getAttributes().add((Object)attribute);
                }
                attribute.setValue(value);
            }
        }
        catch (Exception e) {
            LoggerManager.log((Throwable)e);
        }
    }

    @Override
    public void undo() {
        super.undo();
        if (this.hasWeightsAttribute) {
            XamlNode sashForm = (XamlNode)this.host.getModel();
            String value = SashUtil.weightsValue((int[])this.oldWeights);
            XamlAttribute attribute = sashForm.getAttribute(WIEGHTS_ATTR, "http://www.eclipse.org/xwt/presentation");
            attribute.setValue(value);
        }
    }
}

