/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.palette;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.internal.utils.LoggerManager;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutType;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutsHelper;
import org.eclipse.xwt.tools.ui.designer.preference.Preferences;
import org.eclipse.xwt.tools.ui.palette.Entry;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.xwt.tools.ui.xaml.tools.AnnotationTools;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EntryHelper {
    public static final String CURSOR_CONSTANTS = "${cursor}";
    public static final String ANN_CURSOR_DATA = "CURSOR_DATA_ANN";
    private static Map<Entry, XamlNode> nodes = new HashMap<Entry, XamlNode>();

    public static XamlNode getNode(Entry entry) {
        if (entry == null) {
            return null;
        }
        XamlNode node = nodes.get(entry);
        if (node == null || node.eContainer() != null) {
            try {
                node = new EntryHelper().createNode(entry);
                if ("Composite".equals(node.getName())) {
                    EntryHelper.initLayoutAttribute(node);
                }
                nodes.put(entry, node);
            }
            catch (Exception e) {
                LoggerManager.log((Throwable)e);
            }
        }
        return (XamlNode)EcoreUtil.copy((EObject)node);
    }

    public static void initLayoutAttribute(XamlNode model) {
        XamlAttribute layoutAttr = XamlFactory.eINSTANCE.createAttribute("layout", "http://www.eclipse.org/xwt/presentation");
        String layout = Preferences.getPreferenceStore().getString("Default Layout");
        LayoutType layoutType = LayoutsHelper.getLayoutType(layout);
        if (layoutType != null && LayoutType.NullLayout != layoutType && LayoutType.Unknown != layoutType) {
            XamlElement newLayout = XamlFactory.eINSTANCE.createElement(layoutType.value(), "http://www.eclipse.org/xwt/presentation");
            layoutAttr.getChildNodes().add((Object)newLayout);
            model.getAttributes().add((Object)layoutAttr);
        }
    }

    public static XamlNode getNode(CreateRequest createReq) {
        Object newObject = createReq.getNewObject();
        if (newObject instanceof Entry) {
            return EntryHelper.getNode((Entry)newObject);
        }
        return null;
    }

    private XamlNode createNode(Entry entry) {
        if (entry == null || entry.getContent() == null) {
            return null;
        }
        String content = entry.getContent();
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder domBuilder = domFactory.newDocumentBuilder();
            try {
                Document document = domBuilder.parse(new ByteArrayInputStream(content.getBytes()));
                if (document != null) {
                    Element element = document.getDocumentElement();
                    String name = element.getNodeName();
                    String ns = element.getNamespaceURI();
                    String prefix = element.getPrefix();
                    if (ns == null) {
                        ns = this.getNamespace(prefix);
                    }
                    XamlElement node = null;
                    if (name.indexOf(".") != -1) {
                        name = name.substring(name.indexOf(".") + 1);
                        node = XamlFactory.eINSTANCE.createXamlAttribute();
                        node.setName(name);
                        node.setNamespace(ns);
                    } else {
                        node = XamlFactory.eINSTANCE.createXamlElement();
                        node.setName(name);
                        node.setNamespace(ns);
                    }
                    node.setPrefix(prefix);
                    this.createModel((XamlNode)node, element);
                    return node;
                }
            }
            catch (Exception e) {
                throw new XWTException((Throwable)e);
            }
        }
        catch (ParserConfigurationException e) {
            throw new XWTException((Throwable)e);
        }
        return null;
    }

    private String getNamespace(String prefix) {
        if ("x".equals(prefix)) {
            return "http://www.eclipse.org/xwt";
        }
        return "http://www.eclipse.org/xwt/presentation";
    }

    private void createModel(XamlNode parent, Element text) {
        NodeList childNodes;
        NamedNodeMap attributes = text.getAttributes();
        if (attributes != null) {
            int length = attributes.getLength();
            int i = 0;
            while (i < length) {
                Attr attr = (Attr)attributes.item(i);
                this.createAttribute(parent, attr);
                ++i;
            }
        }
        if ((childNodes = text.getChildNodes()) == null) {
            return;
        }
        int length = childNodes.getLength();
        int i = 0;
        while (i < length) {
            Node item = childNodes.item(i);
            if (item instanceof Element) {
                Element child = (Element)item;
                this.createChild(parent, child);
            }
            ++i;
        }
    }

    private void createChild(XamlNode parent, Element child) {
        String name = child.getNodeName();
        String ns = child.getNamespaceURI();
        String prefix = child.getPrefix();
        if (ns == null) {
            ns = this.getNamespace(prefix);
        }
        if (name.indexOf(".") != -1) {
            name = name.substring(name.indexOf(".") + 1);
            XamlAttribute a = XamlFactory.eINSTANCE.createXamlAttribute();
            a.setName(name);
            a.setNamespace(ns);
            this.createModel((XamlNode)a, child);
            parent.getAttributes().add((Object)a);
        } else {
            XamlElement e = XamlFactory.eINSTANCE.createXamlElement();
            e.setName(name);
            e.setNamespace(ns);
            this.createModel((XamlNode)e, child);
            parent.getChildNodes().add((Object)e);
        }
    }

    private void createAttribute(XamlNode parent, Attr attr) {
        XamlAttribute a;
        if (attr == null) {
            return;
        }
        String name = attr.getName();
        String ns = attr.getNamespaceURI();
        String value = attr.getNodeValue();
        boolean containsCursor = false;
        if (value != null && CURSOR_CONSTANTS.equals(value)) {
            value = "";
            containsCursor = true;
        }
        String prefix = attr.getPrefix();
        int index = name.indexOf(":");
        if (index != -1) {
            prefix = name.substring(0, index);
            name = name.substring(index + 1);
        }
        if (ns == null) {
            ns = this.getNamespace(prefix);
        }
        if ((a = parent.getAttribute(name, ns)) == null) {
            a = XamlFactory.eINSTANCE.createXamlAttribute();
            a.setName(name);
            a.setNamespace(ns);
            a.setPrefix(prefix);
            a.setValue(value);
            parent.getAttributes().add((Object)a);
        } else if (value == null && a.getValue() != null) {
            a.setValue(null);
        } else if (value != null && value != a.getValue()) {
            a.setValue(value);
        }
        if (containsCursor) {
            AnnotationTools.addAnnotation((XamlNode)a, (String)ANN_CURSOR_DATA, (String)name);
        }
    }
}

