/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.databinding;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.internal.utils.UserData;
import org.eclipse.xwt.tools.ui.designer.core.util.swt.SWTTools;
import org.eclipse.xwt.tools.ui.designer.databinding.Observable;

public class ObservableUtil {
    private static final Map<Object, Observable> cache = new HashMap<Object, Observable>(1);

    public static Observable getObservable(Object source) {
        if (source == null) {
            return null;
        }
        Observable observable = cache.get(source);
        if (observable == null) {
            observable = ObservableUtil.createObservable(source, null);
        }
        return observable;
    }

    private static Observable createObservable(Object source, Observable parent) {
        Viewer viewer;
        if (!(source instanceof Viewer) && (viewer = UserData.getLocalViewer((Object)source)) != null) {
            parent = ObservableUtil.createObservable(viewer, parent);
        }
        Observable observable = new Observable(source, parent);
        if (source instanceof Widget) {
            Widget[] children;
            Widget[] widgetArray = children = SWTTools.getChildren((Widget)((Widget)source));
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Widget widget = widgetArray[n2];
                ObservableUtil.createObservable(widget, observable);
                ++n2;
            }
        }
        cache.put(source, observable);
        return observable;
    }
}

