/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.commands;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.xwt.tools.ui.designer.commands.ApplyAttributeSettingCommand;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class ResizeCommand
extends Command {
    private EditPart editPart;
    private Dimension growth;
    private CompoundCommand command;

    public ResizeCommand(EditPart editPart, Dimension growth) {
        this.setLabel("Resize");
        this.editPart = editPart;
        this.growth = growth;
    }

    public boolean canExecute() {
        if (this.editPart == null || this.growth == null || this.growth.width == 0 && this.growth.height == 0) {
            return false;
        }
        Object model = this.editPart.getModel();
        return model != null && model instanceof XamlNode;
    }

    public void execute() {
        int growWidth = 0;
        int growHeight = 0;
        if (this.growth.width != 0) {
            growWidth = this.growth.width;
        }
        if (this.growth.height != 0) {
            growHeight = this.growth.height;
        }
        Dimension size = this.getSize();
        this.command = new CompoundCommand();
        XamlNode model = (XamlNode)this.editPart.getModel();
        if (growWidth != 0) {
            this.command.add(this.createCommand(model, "width", growWidth + size.width));
        }
        if (growHeight != 0) {
            this.command.add(this.createCommand(model, "height", growHeight + size.height));
        }
        if (this.command.canExecute()) {
            this.command.execute();
        }
    }

    private Command createCommand(XamlNode control, String attrName, int value) {
        String newValue = Integer.toString(value);
        CompoundCommand command = new CompoundCommand();
        XamlAttribute layoutDataAttr = control.getAttribute("layoutData");
        if (layoutDataAttr != null && !layoutDataAttr.getChildNodes().isEmpty()) {
            XamlElement layoutData = layoutDataAttr.getChild(0);
            XamlAttribute attribute = layoutData.getAttribute(attrName);
            if (attribute == null) {
                attribute = layoutData.getAttribute(String.valueOf(attrName) + "Hint");
            }
            if (attribute != null) {
                command.add((Command)new ApplyAttributeSettingCommand(null, attribute, newValue));
            }
        }
        if (command.isEmpty()) {
            command.add((Command)new ApplyAttributeSettingCommand(control, attrName, "http://www.eclipse.org/xwt/presentation", newValue));
        } else {
            XamlAttribute attribute = control.getAttribute(attrName);
            if (attribute != null) {
                command.add((Command)new ApplyAttributeSettingCommand(null, attribute, newValue));
            }
        }
        return command.unwrap();
    }

    private Dimension getSize() {
        IFigure contentPane = ((GraphicalEditPart)this.editPart).getContentPane();
        return contentPane.getSize();
    }

    public boolean canUndo() {
        return this.command != null && this.command.canUndo();
    }

    public void undo() {
        this.command.undo();
    }
}

