/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.ceditor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.xwt.tools.ui.designer.core.ceditor.ISourcePage;
import org.eclipse.xwt.tools.ui.designer.core.ceditor.SourcePageRegistry;
import org.eclipse.xwt.tools.ui.designer.core.editor.Designer;

public class MultiSourceEditor
extends MultiPageEditorPart {
    private ISourcePage[] sourcePages;
    private IEditorPart primaryEditor;

    public MultiSourceEditor(IEditorPart primaryEditor) {
        this.primaryEditor = primaryEditor;
        this.sourcePages = SourcePageRegistry.getSourcePages(primaryEditor.getSite().getId());
    }

    protected void createPages() {
        if (!this.testValid()) {
            return;
        }
        ISourcePage[] iSourcePageArray = this.sourcePages;
        int n = this.sourcePages.length;
        int n2 = 0;
        while (n2 < n) {
            ISourcePage sourcePage = iSourcePageArray[n2];
            if (sourcePage.isEnabledFor(this.primaryEditor)) {
                this.createAddPage(sourcePage);
            }
            ++n2;
        }
        Composite container = this.getContainer();
        if (container instanceof CTabFolder) {
            CTabFolder ctf = (CTabFolder)container;
            ctf.setTabPosition(128);
            ctf.setSimple(false);
        }
    }

    private void createAddPage(ISourcePage sourcePage) {
        try {
            int pageIndex = this.addPage(sourcePage, this.getEditorInput());
            String pageName = sourcePage.getPageName();
            this.setPageText(pageIndex, pageName == null ? "" : pageName);
            sourcePage.configureSourcePage((IEditorPart)this);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor != null) {
            activeEditor.doSave(monitor);
        }
    }

    protected void setActivePage(int pageIndex) {
        if (pageIndex < 0 || pageIndex >= this.getPageCount()) {
            return;
        }
        super.setActivePage(pageIndex);
    }

    public void doSaveAs() {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor != null) {
            activeEditor.doSaveAs();
        }
    }

    public boolean isSaveAsAllowed() {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor != null) {
            return activeEditor.isSaveAsAllowed();
        }
        return false;
    }

    public boolean testValid() {
        if (this.sourcePages == null) {
            this.sourcePages = SourcePageRegistry.getSourcePages(this.primaryEditor.getSite().getId());
        }
        if (this.sourcePages.length <= 0) {
            return false;
        }
        boolean enabled = false;
        ISourcePage[] iSourcePageArray = this.sourcePages;
        int n = this.sourcePages.length;
        int n2 = 0;
        while (n2 < n) {
            ISourcePage page = iSourcePageArray[n2];
            enabled = enabled || page.isEnabledFor(null);
            ++n2;
        }
        return enabled;
    }

    public Object getAdapter(Class adapter) {
        if (Designer.class == adapter) {
            return this.primaryEditor;
        }
        return super.getAdapter(adapter);
    }
}

