/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.policies;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.xwt.tools.ui.designer.parts.MenuItemEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.figures.Expandable;
import org.eclipse.xwt.tools.ui.designer.policies.ExpandableEditPolicy;
import org.eclipse.xwt.tools.ui.designer.utils.StyleHelper;

public class MenuItemExpandableEditPolicy
extends ExpandableEditPolicy {
    private ArrayList<Expandable> expandedFigures;

    @Override
    public void expand() {
        List children = this.getHost().getChildren();
        if (children == null || children.isEmpty()) {
            return;
        }
        if (this.expandedFigures == null || this.expandedFigures.isEmpty()) {
            this.expandedFigures = new ArrayList();
            for (Object object : children) {
                IFigure figure;
                if (!(object instanceof GraphicalEditPart) || !((figure = ((GraphicalEditPart)object).getFigure()) instanceof Expandable)) continue;
                this.expandedFigures.add((Expandable)figure);
            }
        }
        this.expandAll();
    }

    private void expandAll() {
        IFigure hostFigure = this.getHostFigure();
        for (Expandable f : this.expandedFigures) {
            IFigure layer = this.getLayer();
            if (f.getParent() != layer) {
                layer.add((IFigure)f);
            }
            Rectangle r = hostFigure.getBounds().getCopy();
            hostFigure.translateToAbsolute((Translatable)r);
            if (r.isEmpty()) continue;
            MenuItem menuItem = (MenuItem)((MenuItemEditPart)this.getHost()).getWidget();
            if (StyleHelper.isOnMenubar(menuItem)) {
                f.setLocation(new Point(r.x + 1, r.y + r.height));
            } else {
                f.setLocation(new Point(r.x + r.width, r.y));
            }
            f.expand();
        }
    }

    @Override
    public void collapse() {
        if (this.expandedFigures != null && !this.expandedFigures.isEmpty()) {
            for (Expandable figure : this.expandedFigures) {
                figure.collapse();
            }
        }
    }
}

