/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.loader;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.IXWTLoader;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTLoaderManager;
import org.eclipse.xwt.internal.utils.UserData;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.metadata.IProperty;
import org.eclipse.xwt.metadata.ModelUtils;
import org.eclipse.xwt.tools.ui.designer.core.util.swt.SWTTools;
import org.eclipse.xwt.tools.ui.designer.loader.ResourceVisitor;
import org.eclipse.xwt.tools.ui.designer.loader.XWTVisualLoader;
import org.eclipse.xwt.tools.ui.designer.swt.CoolBarHelper;
import org.eclipse.xwt.tools.ui.designer.utils.XWTModelUtil;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class XWTProxy {
    public static final Point DEFAULT_SIZE = new Point(200, 100);
    private final ResourceVisitor resourceVisitor;
    private Shell device;
    private Map<XamlNode, Object> componentsMap = new HashMap<XamlNode, Object>();
    private Object rootComponent = null;
    private Map<String, Object> options;

    public XWTProxy(IFile file) {
        Object xwtLoader = XWTLoaderManager.getActive();
        if (xwtLoader == null || !(xwtLoader instanceof XWTVisualLoader)) {
            xwtLoader = new XWTVisualLoader(file);
            XWTLoaderManager.setActive((IXWTLoader)xwtLoader, (boolean)true);
        }
        this.resourceVisitor = new ResourceVisitor((XWTVisualLoader)((Object)xwtLoader));
        this.options = new HashMap<String, Object>();
        this.options.put("XWT.DesignMode", Boolean.TRUE);
    }

    public Object load(XamlElement node, Map<String, Object> options) {
        Object result = this.resourceVisitor.createCLRElement(node, options);
        if (result instanceof Widget) {
            this.buildComponentMap((Widget)result);
        }
        return result;
    }

    public Object load(XamlDocument document) {
        if (document == null) {
            return null;
        }
        XamlElement element = document.getRootElement();
        if (element == null) {
            return null;
        }
        if (this.device == null || this.device.isDisposed()) {
            this.device = new Shell(8);
        }
        this.device.setSize(0, 0);
        this.componentsMap.clear();
        if (!"shell".equalsIgnoreCase(element.getName())) {
            Shell shell = new Shell(this.device);
            Point offset = SWTTools.getOffset((Scrollable)shell);
            shell.setLocation(-offset.x, -offset.y);
            shell.setSize(DEFAULT_SIZE);
            this.options.put("XWT.Container", shell);
        } else {
            this.options.put("XWT.Container", this.device);
        }
        this.rootComponent = this.load(element, this.options);
        if (this.rootComponent == null) {
            return null;
        }
        Control control = null;
        if (this.rootComponent instanceof Shell) {
            Shell shell = (Shell)this.rootComponent;
            XamlAttribute bounds = element.getAttribute("bounds");
            XamlAttribute location = element.getAttribute("location");
            if (bounds == null && location == null) {
                shell.setLocation(0, 0);
            }
        }
        if (this.rootComponent instanceof Control) {
            control = (Control)this.rootComponent;
            this.layout(control);
        } else if (this.rootComponent instanceof Viewer) {
            control = ((Viewer)this.rootComponent).getControl();
        }
        this.layout(control);
        this.device.open();
        this.device.setVisible(false);
        this.buildComponentMap(this.rootComponent);
        return this.rootComponent;
    }

    public void layout(Control control) {
        if (control == null || control.isDisposed() || control == this.device) {
            return;
        }
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Layout layout = composite.getLayout();
            if (layout != null) {
                composite.layout(true, true);
            }
            Control[] childs = composite.getChildren();
            int i = 0;
            while (i < childs.length) {
                if (childs[i] instanceof CoolBar) {
                    CoolBarHelper.layout((CoolBar)childs[i]);
                }
                ++i;
            }
        }
        if (control instanceof CoolBar) {
            CoolBarHelper.layout((CoolBar)control);
        }
        if (control == this.rootComponent && this.autoSize(XWTProxy.getModel(control))) {
            Composite composite;
            Point size = control.computeSize(-1, -1);
            if (control instanceof Composite && (composite = (Composite)control).getChildren().length == 0) {
                size.x = Math.max(size.x, XWTProxy.DEFAULT_SIZE.x);
                size.y = Math.max(size.y, XWTProxy.DEFAULT_SIZE.y);
            }
            control.setSize(size);
            if (control instanceof Composite) {
                ((Composite)control).layout();
            }
        }
        this.layout((Control)control.getParent());
    }

    public Object getRoot() {
        return this.rootComponent;
    }

    protected boolean autoSize(XamlNode xamlNode) {
        XamlAttribute size;
        if (xamlNode == null) {
            return false;
        }
        XamlAttribute bounds = xamlNode.getAttribute("bounds");
        if (bounds == null) {
            bounds = xamlNode.getAttribute("bounds", "http://www.eclipse.org/xwt/presentation");
        }
        if ((size = xamlNode.getAttribute("size")) == null) {
            size = xamlNode.getAttribute("size", "http://www.eclipse.org/xwt/presentation");
        }
        return bounds == null && size == null;
    }

    public boolean shouldPack(XamlElement element) {
        return this.autoSize((XamlNode)element) && !element.getChildNodes().isEmpty();
    }

    public Object createWidget(Object parent, XamlElement node) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("XWT.Container", parent);
        return this.load(node, options);
    }

    public Object getComponent(EObject node) {
        return this.componentsMap.get(node);
    }

    public Object getComponent(EObject node, boolean loadOnDemand) {
        Object component = this.getComponent(node);
        if (!loadOnDemand) {
            return component;
        }
        if (this.isNull(component)) {
            Object parentComponent;
            EObject container = node.eContainer();
            while (container != null && !(container instanceof XamlElement)) {
                container = container.eContainer();
            }
            if (container != null && !this.isNull(parentComponent = this.getComponent(container, loadOnDemand))) {
                component = this.createWidget(parentComponent, (XamlElement)node);
            }
        }
        return component;
    }

    public boolean isNull(Object component) {
        if (component == null) {
            return true;
        }
        if (component instanceof Widget) {
            return ((Widget)component).isDisposed();
        }
        if (component instanceof Viewer) {
            return ((Viewer)component).getControl() == null || ((Viewer)component).getControl().isDisposed();
        }
        return false;
    }

    private void buildComponentMap(Object component) {
        if (component == null) {
            return;
        }
        XamlNode key = null;
        Control widget = null;
        if (component instanceof Viewer) {
            widget = ((Viewer)component).getControl();
            key = (XamlNode)((Viewer)component).getData("XWTDesigner.Model");
            if (key != null) {
                this.componentsMap.put(key, component);
                key = XWTModelUtil.getAdaptableAttribute(key, "control", "http://www.eclipse.org/xwt/presentation");
            }
        } else if (component instanceof Widget) {
            widget = (Widget)component;
            key = (XamlNode)widget.getData("XWTDesigner.Model");
        }
        if (key != null) {
            this.componentsMap.put(key, widget);
        }
        if (widget != null && !widget.isDisposed()) {
            Widget[] children;
            Widget[] widgetArray = children = SWTTools.getChildren((Widget)widget);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Widget child = widgetArray[n2];
                Viewer viewer = UserData.getLocalViewer((Object)child);
                if (viewer != null) {
                    this.buildComponentMap(viewer);
                } else {
                    this.buildComponentMap(child);
                }
                ++n2;
            }
        }
    }

    public Object doCreate(XamlElement element) {
        try {
            return this.resourceVisitor.doCreate(null, element, null, Collections.EMPTY_MAP);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object createValue(XamlElement element) {
        return new XWTProxy(null).doCreate(element);
    }

    public boolean isDisposed() {
        return this.device == null || this.device.isDisposed();
    }

    public boolean reset() {
        return this.dispose();
    }

    public boolean dispose() {
        return this.destroy(this.rootComponent) && this.destroy(this.device);
    }

    public boolean destroy(Object component) {
        if (component == null) {
            return false;
        }
        if (component instanceof Widget) {
            Menu menuBar;
            Decorations parent;
            Widget widget = (Widget)component;
            XamlNode model = XWTProxy.getModel(widget);
            if (model != null) {
                this.componentsMap.remove(model);
            }
            if (widget instanceof Menu && (parent = ((Menu)widget).getParent()) instanceof Shell && (menuBar = ((Shell)parent).getMenuBar()) == widget) {
                ((Shell)parent).setMenuBar(null);
            }
            widget.dispose();
        } else if (component instanceof Viewer) {
            this.destroy(((Viewer)component).getControl());
        }
        component = null;
        return true;
    }

    public boolean removeValue(Object object, XamlAttribute attribute) {
        if (!(object instanceof Widget) && "style".equals(attribute.getName())) {
            return false;
        }
        IMetaclass metaclass = XWT.getMetaclass((Object)object);
        if (metaclass == null) {
            return false;
        }
        Object defaultValue = this.getDefaultValue(object, attribute);
        try {
            String name = ModelUtils.normalizePropertyName((String)attribute.getName());
            IProperty property = metaclass.findProperty(name);
            if (property != null) {
                property.setValue(object, defaultValue);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public Object getDefaultValue(Object object, XamlAttribute attribute) {
        EObject container;
        if (object == null || attribute == null || attribute.getName() == null) {
            return null;
        }
        String name = attribute.getName();
        if (object instanceof Widget && "visible".equalsIgnoreCase(name) && "http://www.eclipse.org/xwt/presentation".endsWith(attribute.getNamespace())) {
            return true;
        }
        XamlNode model = null;
        if (object instanceof Widget) {
            model = XWTProxy.getModel((Widget)object);
        }
        if (model == null && (container = attribute.eContainer()) instanceof XamlElement) {
            model = (XamlElement)container;
        }
        if (model == null) {
            return null;
        }
        XamlElement newModel = (XamlElement)EcoreUtil.copy((EObject)model);
        IMetaclass metaclass = XWTUtility.getMetaclass((XamlNode)newModel);
        if (metaclass == null || !Control.class.isAssignableFrom(metaclass.getType())) {
            return null;
        }
        Shell shell = new Shell(this.device);
        Object tempObj = this.createWidget(shell, (XamlElement)EcoreUtil.copy((EObject)model));
        if (tempObj == null || !(tempObj instanceof Widget)) {
            return false;
        }
        try {
            if ("style".equalsIgnoreCase(name) && "http://www.eclipse.org/xwt".endsWith(attribute.getNamespace())) {
                Integer n = ((Widget)tempObj).getStyle();
                return n;
            }
            IProperty p = metaclass.findProperty(name);
            if (p != null) {
                Object object2 = p.getValue(tempObj);
                return object2;
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.destroy(tempObj);
            this.destroy(shell);
        }
        return null;
    }

    public boolean initAttribute(Object component, XamlAttribute attribute) {
        try {
            XamlElement container = (XamlElement)attribute.eContainer();
            IMetaclass metaclass = XWTUtility.getMetaclass((XamlNode)container);
            String attrName = attribute.getName();
            String namespace = attribute.getNamespace();
            if (container != null && metaclass != null && attrName != null) {
                this.resourceVisitor.initAttribute(metaclass, component, (XamlNode)container, namespace, attrName);
                this.buildComponentMap(component);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String getClr() {
        Object clr;
        if (this.rootComponent == null) {
            return null;
        }
        Widget widget = null;
        if (this.rootComponent instanceof Widget) {
            widget = (Widget)this.rootComponent;
        } else if (this.rootComponent instanceof Viewer) {
            widget = ((Viewer)this.rootComponent).getControl();
        }
        if (widget != null && !widget.isDisposed() && (clr = UserData.getCLR((Object)widget)) != null) {
            return clr.getClass().getName();
        }
        return null;
    }

    public static XamlNode getModel(Object component) {
        if (component == null) {
            return null;
        }
        if (component instanceof Widget && !((Widget)component).isDisposed()) {
            return (XamlNode)((Widget)component).getData("XWTDesigner.Model");
        }
        if (component instanceof Viewer) {
            return (XamlNode)((Viewer)component).getData("XWTDesigner.Model");
        }
        return null;
    }

    public boolean removeLayout(Composite composite) {
        if (composite == null || composite.isDisposed()) {
            return false;
        }
        composite.setLayout(null);
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setLayoutData(null);
            ++n2;
        }
        return true;
    }

    public boolean recreate(Widget widget) {
        XamlNode model = null;
        if (widget != null && !widget.isDisposed()) {
            model = XWTProxy.getModel(widget);
        }
        if (model == null) {
            return false;
        }
        if (widget instanceof Control) {
            Control control = (Control)widget;
            Composite composite = control.getParent();
            boolean cfr_ignored_0 = composite instanceof SashForm;
        }
        this.destroy(this.rootComponent);
        this.componentsMap.clear();
        this.load(model.getOwnerDocument());
        if (model != null) {
            Composite parent;
            widget = (Widget)this.componentsMap.get(model);
            if (widget instanceof TabItem) {
                TabItem tabItem = (TabItem)widget;
                tabItem.getParent().setSelection(tabItem);
            } else if (widget instanceof Control && (parent = ((Control)widget).getParent()) instanceof TabFolder) {
                TabFolder tabFolder = (TabFolder)parent;
                TabItem[] tabItemArray = tabFolder.getItems();
                int n = tabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TabItem item = tabItemArray[n2];
                    if (item.getControl() == widget) {
                        tabFolder.setSelection(item);
                        break;
                    }
                    ++n2;
                }
            }
        }
        return widget != null && !widget.isDisposed();
    }
}

