/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.palette;

import java.lang.reflect.Constructor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.tools.ui.designer.editor.palette.EntryHelper;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class CreateReqHelper {
    public static final Object UNKNOWN_TYPE = new Object();
    private CreateRequest createReq;

    public CreateReqHelper(CreateRequest createReq) {
        this.createReq = createReq;
    }

    public XamlNode getNewObject() {
        return EntryHelper.getNode(this.createReq);
    }

    public String getNewObjectType() {
        Object type = this.createReq.getType();
        if (type != null) {
            return type.toString();
        }
        return null;
    }

    public Object getCreateType() {
        return CreateReqHelper.getCreateType(this.getNewObject());
    }

    public static Object getCreateType(Object newObject) {
        if (newObject != null && newObject instanceof XamlElement) {
            return CreateReqHelper.getType((XamlNode)((XamlElement)newObject));
        }
        if (newObject instanceof XamlAttribute) {
            return ((XamlAttribute)newObject).getName();
        }
        return UNKNOWN_TYPE;
    }

    public static Class<?> getType(XamlNode element) {
        if (element == null) {
            return null;
        }
        IMetaclass metaclass = XWTUtility.getMetaclass(element);
        if (metaclass != null) {
            return metaclass.getType();
        }
        return null;
    }

    public boolean isCreate(Object targetType) {
        if (targetType == null) {
            return false;
        }
        Object createType = CreateReqHelper.getCreateType(this.getNewObject());
        if (targetType instanceof String && createType instanceof String) {
            return ((String)targetType).equalsIgnoreCase((String)createType);
        }
        return targetType == createType;
    }

    public static boolean canCreate(Object parent, Object child) {
        Class<?> parentType;
        XamlNode parentNode;
        block21: {
            Object model;
            parentNode = null;
            parentType = null;
            if (parent instanceof Class) {
                parentType = (Class<?>)parent;
            } else if (parent instanceof XamlNode) {
                parentNode = (XamlNode)parent;
            } else if (parent instanceof EditPart && (model = ((EditPart)parent).getModel()) instanceof XamlNode) {
                parentNode = (XamlNode)model;
            }
            if (parentType == null && parentNode != null) {
                parentType = CreateReqHelper.getType(parentNode);
            }
            if (parentType != null && parentType != CCombo.class) break block21;
            return false;
        }
        try {
            boolean canCreate = false;
            Object createType = CreateReqHelper.getCreateType(child);
            if (createType instanceof Class) {
                Constructor<?>[] constructors;
                Class type = (Class)createType;
                if (ExpandItem.class.isAssignableFrom(type)) {
                    return ExpandBar.class.isAssignableFrom(parentType);
                }
                if (ToolItem.class.isAssignableFrom(type)) {
                    return ToolBar.class.isAssignableFrom(parentType);
                }
                if (CoolItem.class.isAssignableFrom(type)) {
                    return CoolBar.class.isAssignableFrom(parentType);
                }
                if (TabItem.class.isAssignableFrom(type)) {
                    return TabFolder.class.isAssignableFrom(parentType);
                }
                if (CTabItem.class.isAssignableFrom(type)) {
                    return CTabFolder.class.isAssignableFrom(parentType);
                }
                Constructor<?>[] constructorArray = constructors = ((Class)createType).getConstructors();
                int n = constructors.length;
                int n2 = 0;
                while (n2 < n) {
                    Constructor<?> constructor = constructorArray[n2];
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length != 0 && parameterTypes[0].isAssignableFrom(parentType)) {
                        canCreate = true;
                        break;
                    }
                    ++n2;
                }
            } else if (createType instanceof String) {
                String stringType = (String)createType;
                IMetaclass metaclass = XWT.getMetaclass(parentType);
                if (metaclass != null) {
                    boolean bl = canCreate = metaclass.findProperty((String)createType) != null;
                    if ("menuBar".equals(stringType) || "menu".equals(stringType) || "layoutData".equals(stringType)) {
                        canCreate = canCreate && parentNode.getAttribute(stringType) == null;
                    }
                }
            }
            return canCreate;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean canCreate(Object parent) {
        return CreateReqHelper.canCreate(parent, this.getNewObject());
    }

    public boolean isKindOf(String nodeName, String namespace, String targetType) {
        if (nodeName == null || namespace == null || targetType == null) {
            return false;
        }
        if ("Composite".equalsIgnoreCase(targetType)) {
            IMetaclass metaclass = XWT.getMetaclass((String)nodeName, (String)namespace);
            if (metaclass == null) {
                return false;
            }
            return Composite.class.isAssignableFrom(metaclass.getType());
        }
        if ("Control".equalsIgnoreCase(targetType)) {
            IMetaclass metaclass = XWT.getMetaclass((String)nodeName, (String)namespace);
            if (metaclass == null) {
                return false;
            }
            return Control.class.isAssignableFrom(metaclass.getType());
        }
        return targetType.equalsIgnoreCase(nodeName);
    }
}

