/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.tools.ui.designer.editor.XWTDesigner;
import org.eclipse.xwt.tools.ui.designer.loader.XWTProxy;
import org.eclipse.xwt.tools.ui.designer.resources.ImageShop;

public class PreviewAction
extends SelectionAction {
    public static final String ACTION_ID = "org.eclipse.xwt.tools.ui.designer.editor.actions.PreviewAction";
    private XWTDesigner part;
    private static Point defaultSize;

    public PreviewAction(XWTDesigner part) {
        super((IWorkbenchPart)part);
        this.part = part;
        this.setId(ACTION_ID);
        this.setText("Test/Preview");
        this.setToolTipText("Quickly test/preview with XWT loader");
        this.setImageDescriptor(ImageShop.getImageDescriptor("/icons/full/tools/preview.png"));
    }

    public void run() {
        try {
            IFile inputFile = this.part.getFile();
            String content = this.part.getDocument().get();
            Object element = XWT.load((InputStream)new ByteArrayInputStream(content.getBytes()), (URL)inputFile.getLocationURI().toURL());
            if (!(element instanceof Control)) {
                throw new XWTException("Root element is a control.");
            }
            Control control = (Control)element;
            if (control == null || control.isDisposed()) {
                return;
            }
            Shell shell = control.getShell();
            Point size = shell.getSize();
            Point dSize = PreviewAction.defaultSize();
            if (size.x == dSize.x && size.y == dSize.y) {
                Point computeSize = control.computeSize(-1, -1);
                Point defaultSize = XWTProxy.DEFAULT_SIZE;
                int x = Math.max(computeSize.x, defaultSize.x);
                int y = Math.max(computeSize.y, defaultSize.y);
                boolean pack = false;
                if (!(control instanceof Shell)) {
                    shell.setLayout(null);
                    pack = true;
                }
                control.setSize(x, y);
                if (pack) {
                    shell.pack();
                }
            }
            shell.open();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Point defaultSize() {
        if (defaultSize == null) {
            defaultSize = new Shell().getSize();
        }
        return defaultSize;
    }

    protected boolean calculateEnabled() {
        return this.part != null && this.part.getDocument() != null;
    }
}

