/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.tools.ui.designer.core.editor.AbstractRenderer;
import org.eclipse.xwt.tools.ui.designer.core.editor.IVisualRenderer;
import org.eclipse.xwt.tools.ui.designer.core.util.SashUtil;
import org.eclipse.xwt.tools.ui.designer.loader.XWTProxy;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class XWTVisualRenderer
extends AbstractRenderer {
    private final XWTProxy proxy;

    public XWTVisualRenderer(IFile file, XamlDocument document) {
        super(file, (EObject)document);
        if (document == null) {
            throw new RuntimeException("XamlDocument is null");
        }
        document.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                XWTVisualRenderer.this.recreate();
            }
        });
        this.proxy = new XWTProxy(file);
    }

    public Object getVisual(EObject model, boolean loadOnDemand) {
        return this.proxy.getComponent(model, loadOnDemand);
    }

    public Object getVisual(EObject model) {
        return this.proxy.getComponent((EObject)((XamlNode)model));
    }

    public IVisualRenderer.Result updateControls(Notification msg) {
        if (this.proxy.isDisposed() || msg.isTouch()) {
            return null;
        }
        Object notifier = msg.getNotifier();
        Object oldValue = msg.getOldValue();
        Object newValue = msg.getNewValue();
        if (notifier == null || oldValue == null && newValue == null) {
            return null;
        }
        if (oldValue != null && oldValue != newValue || oldValue == null && newValue != null) {
            return this.applyNewValue(msg);
        }
        return null;
    }

    private boolean canRender(XamlNode node) {
        IMetaclass metaclass;
        block5: {
            if (node == null) {
                return false;
            }
            String name = node.getName();
            if ("http://www.eclipse.org/xwt".equals(node.getNamespace())) {
                return false;
            }
            try {
                metaclass = XWT.getMetaclass((String)(String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1)), (String)node.getNamespace());
                if (metaclass != null) break block5;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        Class type = metaclass.getType();
        return Widget.class.isAssignableFrom(type) || Viewer.class.isAssignableFrom(type);
    }

    private IVisualRenderer.Result applyNewValue(Notification msg) {
        boolean updated = false;
        XamlElement updateObj = null;
        Object notifier = msg.getNotifier();
        Object newValue = msg.getNewValue();
        Object oldValue = msg.getOldValue();
        if (notifier instanceof XamlDocument && newValue instanceof XamlElement) {
            this.proxy.doCreate((XamlElement)newValue);
            return new IVisualRenderer.Result(notifier, true);
        }
        EObject notifyEObject = (EObject)notifier;
        Object parent = this.proxy.getComponent(notifyEObject);
        while (parent == null) {
            notifier = notifyEObject;
            if ((notifyEObject = notifyEObject.eContainer()) == null) break;
            parent = this.proxy.getComponent(notifyEObject);
        }
        if (notifyEObject != null && notifyEObject instanceof XamlElement) {
            updateObj = (XamlElement)notifyEObject;
        }
        switch (msg.getEventType()) {
            case 3: {
                String value;
                XamlAttribute attribute;
                if (this.proxy.isNull(parent)) break;
                if (parent instanceof SashForm && (attribute = updateObj.getAttribute("weights", "http://www.eclipse.org/xwt/presentation")) != null && (value = attribute.getValue()) != null && value.length() > 0) {
                    int[] segments = SashUtil.toWeights((String)value);
                    SashForm sashForm = (SashForm)parent;
                    Control[] children = sashForm.getChildren();
                    int c = 0;
                    int i = 0;
                    while (i < children.length) {
                        if (children[i] instanceof Sash) {
                            ++c;
                        }
                        ++i;
                    }
                    if (children.length > 0) {
                        ++c;
                    }
                    if (c != segments.length) {
                        value = SashUtil.updateWeightsLengh((int[])segments, (int)c);
                        attribute.setValue(value);
                    }
                }
                if (newValue instanceof XamlElement && parent != null && this.canRender((XamlNode)((XamlElement)newValue))) {
                    if (!(parent instanceof Widget)) break;
                    updated = this.proxy.recreate((Widget)parent);
                    updateObj = null;
                    break;
                }
                if (notifier instanceof XamlAttribute) {
                    attribute = (XamlAttribute)notifier;
                    updated = this.applyAttribute(parent, updateObj, attribute);
                    break;
                }
                if (!(newValue instanceof XamlAttribute)) break;
                attribute = (XamlAttribute)newValue;
                updated = this.applyAttribute(parent, updateObj, attribute);
                break;
            }
            case 1: 
            case 2: {
                EObject eContainer;
                if (this.proxy.isNull(parent) || !(notifier instanceof XamlAttribute)) break;
                XamlAttribute attribute = (XamlAttribute)notifier;
                updated = this.applyAttribute(parent, updateObj, attribute);
                if (updateObj == null || !(parent instanceof Item) || (eContainer = updateObj.eContainer()) == null || !(eContainer instanceof XamlElement)) break;
                updateObj = (XamlElement)eContainer;
                break;
            }
            case 4: {
                if (oldValue instanceof XamlElement) {
                    String value;
                    XamlAttribute attribute;
                    Object removeWidget = this.getVisual((EObject)((XamlElement)oldValue));
                    if (parent instanceof SashForm && (attribute = updateObj.getAttribute("weights", "http://www.eclipse.org/xwt/presentation")) != null && (value = attribute.getValue()) != null && value.length() > 0) {
                        SashForm sashForm = (SashForm)parent;
                        Control[] children = sashForm.getChildren();
                        int index = 0;
                        int c = 0;
                        int i = 0;
                        while (i < children.length) {
                            if (removeWidget == children[i]) {
                                index = c;
                            }
                            if (children[i] instanceof Sash) {
                                ++c;
                            }
                            ++i;
                        }
                        if (children.length > 0) {
                            ++c;
                        }
                        if (c <= 2) {
                            updateObj.getAttributes().remove((Object)attribute);
                        } else {
                            value = SashUtil.removeWeights((String)value, (int)index);
                            attribute.setValue(value);
                        }
                    }
                    if (removeWidget != null) {
                        updated = this.proxy.destroy(removeWidget);
                    }
                    if (!(parent instanceof Composite)) break;
                    IMetaclass metaclass = XWTUtility.getMetaclass((XamlNode)((XamlElement)oldValue));
                    if (metaclass != null && Layout.class.isAssignableFrom(metaclass.getType())) {
                        updated = this.proxy.removeLayout((Composite)parent);
                    }
                    this.proxy.layout((Control)((Composite)parent));
                    break;
                }
                if (notifier instanceof XamlAttribute) {
                    XamlAttribute attribute = (XamlAttribute)notifier;
                    updated = this.applyAttribute(parent, updateObj, attribute);
                    break;
                }
                if (!(oldValue instanceof XamlAttribute)) break;
                XamlAttribute attribute = (XamlAttribute)oldValue;
                updated = this.removeAttribute(parent, updateObj, attribute);
                break;
            }
            case 7: {
                if (this.proxy.isNull(parent)) break;
                if (parent instanceof Widget) {
                    updated = this.proxy.recreate((Widget)parent);
                    updateObj = null;
                }
                if (!(parent instanceof Composite)) break;
                this.proxy.layout((Control)((Composite)parent));
                break;
            }
            case 5: 
            case 6: {
                List removed = (List)oldValue;
                for (Object object : removed) {
                    if (!(object instanceof XamlElement)) continue;
                    Object widget = this.getVisual((EObject)((XamlElement)object));
                    this.proxy.destroy(widget);
                    updated = true;
                }
                if (parent == null || !(parent instanceof Composite)) break;
                this.proxy.layout((Control)((Composite)parent));
            }
        }
        return new IVisualRenderer.Result((Object)updateObj, updated);
    }

    private boolean applyAttribute(Object parent, XamlElement element, XamlAttribute attribute) {
        EObject eContainer;
        if (this.proxy.isNull(parent) || attribute == null) {
            return false;
        }
        if ("style".equalsIgnoreCase(attribute.getName()) && "http://www.eclipse.org/xwt".equals(attribute.getNamespace())) {
            if (this.needRecreate(parent, attribute)) {
                return this.proxy.recreate((Widget)parent);
            }
            return false;
        }
        boolean updated = this.proxy.initAttribute(parent, attribute);
        if (element != null && parent instanceof Item && (eContainer = element.eContainer()) != null && eContainer instanceof XamlElement && this.proxy.getComponent((EObject)(element = (XamlElement)eContainer)) instanceof Control) {
            Control control = (Control)this.proxy.getComponent((EObject)element);
            this.proxy.layout(control);
        }
        if (parent instanceof Control) {
            Control control = (Control)parent;
            this.proxy.layout(control);
        }
        return updated;
    }

    private boolean needRecreate(Object parent, XamlAttribute attr) {
        if (parent == null || !(parent instanceof Widget) || attr == null) {
            return false;
        }
        Widget widget = (Widget)parent;
        int oldStyle = widget.getStyle();
        String newStyleStr = attr.getValue();
        int newStyle = (Integer)XWT.convertFrom(Integer.class, (String)newStyleStr);
        return newStyle != oldStyle;
    }

    private boolean removeAttribute(Object parent, XamlElement element, XamlAttribute attribute) {
        if (this.proxy.isNull(parent) || attribute == null) {
            return false;
        }
        if ("style".equalsIgnoreCase(attribute.getName()) && "http://www.eclipse.org/xwt".equals(attribute.getNamespace())) {
            int oldStyle;
            Object defaultValue = this.proxy.getDefaultValue(parent, attribute);
            if (defaultValue != null && defaultValue instanceof Integer && ((oldStyle = ((Integer)XWT.convertFrom(Integer.class, (String)attribute.getValue())).intValue()) & (Integer)defaultValue) == 0) {
                return this.proxy.recreate((Widget)parent);
            }
            return false;
        }
        boolean updated = this.proxy.removeValue(parent, attribute);
        if (parent instanceof Control) {
            Control control = (Control)parent;
            this.proxy.layout(control);
        }
        return updated;
    }

    public void dispose() {
        this.proxy.dispose();
    }

    public String getHostClassName() {
        XamlElement root;
        XamlAttribute attribute;
        String clr = this.proxy.getClr();
        XamlDocument documentRoot = (XamlDocument)this.getDocumentRoot();
        if (clr == null && documentRoot != null && (attribute = (root = documentRoot.getRootElement()).getAttribute("Class", "http://www.eclipse.org/xwt")) != null) {
            return attribute.getValue();
        }
        return clr;
    }

    public void recreate() {
        if (this.getDocumentRoot() == null) {
            return;
        }
        this.proxy.reset();
        this.createVisuals();
    }

    public IVisualRenderer.Result createVisuals() {
        return new IVisualRenderer.Result(this.proxy.load((XamlDocument)this.getDocumentRoot()));
    }

    public IVisualRenderer.Result refreshVisuals(Object source) {
        if (source instanceof Notification) {
            return this.updateControls((Notification)source);
        }
        return null;
    }

    public Object getRoot() {
        return this.proxy.getRoot();
    }
}

