/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.databinding.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.xwt.tools.ui.designer.databinding.BindingContext;
import org.eclipse.xwt.tools.ui.designer.databinding.IObservable;
import org.eclipse.xwt.tools.ui.designer.databinding.Property;
import org.eclipse.xwt.tools.ui.designer.databinding.ui.IGroup;
import org.eclipse.xwt.tools.ui.designer.databinding.ui.ObservableList;
import org.eclipse.xwt.tools.ui.designer.resources.ImageShop;

public abstract class ObserveGroup
implements IGroup {
    private Label messageLabel;
    private Text filterText;
    protected BindingContext bindingContext;
    protected ObservableList observableList;
    protected TreeViewer propertiesTree;
    private boolean dispatching = false;
    private EditPart rootEditPart;
    private TreeViewer treeViewer;

    public ObserveGroup(BindingContext bindingContext, EditPart rootEditPart) {
        this.bindingContext = bindingContext;
        this.rootEditPart = rootEditPart;
    }

    @Override
    public Composite createGroup(Composite parent, int style) {
        Composite group = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        group.setLayout((Layout)layout);
        this.messageLabel = new Label(group, 0);
        this.updateMessage();
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.messageLabel.setLayoutData((Object)layoutData);
        this.filterText = new Text(group, 384);
        layoutData = new GridData(768);
        this.filterText.setLayoutData((Object)layoutData);
        this.filterText.setMessage("type filter text");
        ToolBar toolBar = new ToolBar(group, 0x800000);
        ToolItem item = new ToolItem(toolBar, 8);
        item.setImage(ImageShop.get("/icons/full/tools/clear_filter.gif"));
        item.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ObserveGroup.this.filterText.setText("");
                ObserveGroup.this.filterText.setMessage("type filter text");
            }
        });
        this.filterText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail != 256) {
                    ObserveGroup.this.applyFilter();
                }
            }
        });
        this.observableList = new ObservableList(this.bindingContext, group);
        Control control = this.observableList.getControl();
        layoutData = new GridData(1808);
        control.setLayoutData((Object)layoutData);
        Composite propComp = new Composite(group, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        propComp.setLayout((Layout)layout);
        new Label(propComp, 0).setText("Properties");
        this.treeViewer = this.observableList.getTreeViewer();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ObserveGroup.this.handleObservableChanged(event);
            }
        });
        this.treeViewer.setInput((Object)this.computeObservables(this.rootEditPart));
        this.propertiesTree = new TreeViewer(propComp, 2816);
        this.propertiesTree.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public boolean hasChildren(Object element) {
                if (element instanceof Property) {
                    return ((Property)element).hasChildren();
                }
                return false;
            }

            public Object getParent(Object element) {
                if (element instanceof Property) {
                    return ((Property)element).getParent();
                }
                return null;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof Property) {
                    return ((Property)parentElement).getProperties();
                }
                return new Object[0];
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof IObservable) {
                    return ((IObservable)inputElement).getProperties();
                }
                return new Object[0];
            }
        });
        this.propertiesTree.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Property) {
                    return ((Property)element).getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof Property) {
                    return ImageShop.getImageForType(((Property)element).getType());
                }
                return super.getImage(element);
            }
        });
        this.propertiesTree.getTree().setLayoutData((Object)new GridData(1808));
        this.propertiesTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ObserveGroup.this.handlePropertyChanged(event);
            }
        });
        layoutData = new GridData(1808);
        propComp.setLayoutData((Object)layoutData);
        this.bindingContext.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ObserveGroup.this.refreshGroup(evt);
            }
        });
        return group;
    }

    private void refreshGroup(PropertyChangeEvent evt) {
        if (this.dispatching) {
            return;
        }
        this.selectAndReveal(evt);
    }

    protected abstract IObservable[] computeObservables(EditPart var1);

    protected abstract void selectAndReveal(PropertyChangeEvent var1);

    protected StructuredSelection createSelection(Object object) {
        if (object == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection(object);
    }

    private void handleObservableChanged(SelectionChangedEvent event) {
        this.dispatching = true;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object firstElement = selection.getFirstElement();
        this.propertiesTree.setInput(firstElement);
        this.handleSelection(selection);
        this.updateMessage();
        this.dispatching = false;
    }

    private void handlePropertyChanged(SelectionChangedEvent event) {
        this.dispatching = true;
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        this.handleSelection(selection);
        this.updateMessage();
        this.dispatching = false;
    }

    protected abstract void handleSelection(IStructuredSelection var1);

    protected void applyFilter() {
        this.observableList.applyFilter(this.filterText.getText());
    }

    protected void updateMessage() {
        if (this.messageLabel == null || this.messageLabel.isDisposed()) {
            return;
        }
        String message = this.computeMessage();
        if (message == null) {
            message = "";
        }
        this.messageLabel.setText(message);
    }

    protected abstract String computeMessage();

    @Override
    public void setInput(Object input) {
        if (this.observableList == null) {
            return;
        }
        this.observableList.setInput(input);
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    public void setRootEditPart(EditPart rootEditPart) {
        this.rootEditPart = rootEditPart;
        this.setInput(this.computeObservables(rootEditPart));
    }
}

