/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.util.swt;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.tools.ui.designer.core.util.swt.SWTUtil;
import org.eclipse.xwt.tools.ui.designer.core.util.swt.SWTWorkarounds;

public class WidgetLocator {
    public static Rectangle toDisplay(Rectangle bounds, Control control) {
        if (control instanceof Shell || control.getParent() == null) {
            return bounds;
        }
        Point point = control.getParent().toDisplay(bounds.x, bounds.y);
        return new Rectangle(point.x, point.y, bounds.width, bounds.height);
    }

    public static Rectangle getBounds(Widget w, boolean toDisplay) {
        if (w instanceof Control) {
            Control control = (Control)w;
            Rectangle r = control.getBounds();
            if (toDisplay) {
                return WidgetLocator.toDisplay(r, control);
            }
            Composite parent = control.getParent();
            if (parent instanceof Scrollable && !(parent instanceof Group) && !(parent instanceof TabFolder) && !(parent instanceof CTabFolder)) {
                Shell shell;
                Menu menu;
                Rectangle calced = parent.computeTrim(0, 0, 0, 0);
                r.x += -calced.x;
                r.y += -calced.y;
                if (parent instanceof Shell && SWTUtil.IsWindows && (menu = (shell = (Shell)parent).getMenuBar()) != null && menu.getItemCount() == 0) {
                    r.y -= 19;
                }
            } else if (SWTUtil.IsCocoa && parent instanceof Group) {
                Rectangle calced = parent.computeTrim(0, 0, 0, 0);
                r.x += -calced.x;
                r.y += calced.height + calced.y;
            }
            return r;
        }
        if (w instanceof Menu) {
            Menu menu = (Menu)w;
            menu.getDisplay().update();
            return SWTWorkarounds.getBounds(menu);
        }
        if (w instanceof CTabItem) {
            return SWTWorkarounds.getBounds((CTabItem)w);
        }
        if (w instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)w;
            Menu parent = menuItem.getParent();
            Rectangle r = SWTWorkarounds.getBounds(parent);
            Rectangle bounds = SWTWorkarounds.getBounds((MenuItem)w);
            if (!r.isEmpty() && bounds.isEmpty()) {
                bounds = WidgetLocator.getBounds(menuItem);
            }
            if (bounds.x >= r.x) {
                bounds.x -= r.x;
            }
            if (bounds.y >= r.y) {
                bounds.y -= r.y;
            }
            return bounds;
        }
        if (w instanceof TabItem) {
            return SWTWorkarounds.getBounds((TabItem)w);
        }
        if (w instanceof TableColumn) {
            return SWTWorkarounds.getBounds((TableColumn)w);
        }
        if (w instanceof TreeColumn) {
            return SWTWorkarounds.getBounds((TreeColumn)w);
        }
        if (w instanceof ScrollBar) {
            return SWTWorkarounds.getBounds((ScrollBar)w);
        }
        if (w instanceof ToolItem) {
            return SWTWorkarounds.getBounds((ToolItem)w);
        }
        if (w instanceof CoolItem) {
            return SWTWorkarounds.getBounds((CoolItem)w);
        }
        if (w instanceof TreeItem) {
            return SWTWorkarounds.getBounds((TreeItem)w);
        }
        if (w instanceof TableItem) {
            return SWTWorkarounds.getBounds((TableItem)w);
        }
        if (w instanceof ExpandItem) {
            return SWTWorkarounds.getBounds((ExpandItem)w);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    private static Rectangle getBounds(MenuItem menuItem) {
        if (menuItem == null || menuItem.isDisposed()) {
            return new Rectangle(0, 0, 0, 0);
        }
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 19;
        if ((2 & menuItem.getStyle()) != 0) {
            height = 1;
        } else {
            String text = menuItem.getText();
            Dimension textExtents = FigureUtilities.getTextExtents((String)text, (Font)Display.getCurrent().getSystemFont());
            width = textExtents.width + 12;
            if (menuItem.getImage() != null) {
                width += 20;
            }
        }
        Menu parent = menuItem.getParent();
        int index = parent.indexOf(menuItem);
        int i = 0;
        while (i < index) {
            if (i - 1 >= 0) {
                MenuItem prev = parent.getItem(i - 1);
                Rectangle r = WidgetLocator.getBounds(prev);
                if ((2 & parent.getStyle()) != 0) {
                    x = r.x + r.width;
                    y = r.y;
                } else {
                    y = r.y + r.height;
                }
            }
            ++i;
        }
        return new Rectangle(x, y, width, height);
    }

    public static Point getLocation(Widget widget) {
        Rectangle bounds = WidgetLocator.getBounds(widget, false);
        if (bounds != null) {
            return new Point(bounds.x, bounds.y);
        }
        return null;
    }
}

