/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.util.image;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.xwt.tools.ui.designer.core.util.image.ImageCollectedRunnable;
import org.eclipse.xwt.tools.ui.designer.core.util.swt.SWTUtil;
import org.eclipse.xwt.tools.ui.imagecapture.swt.ImageCapture;

public class ImageCollector {
    static int i = 0;

    public static Shell activeShell(Control control) {
        Shell controlShell = control.getShell();
        Display display = control.getDisplay();
        Control focusControl = display.getFocusControl();
        if (focusControl != null && !focusControl.isDisposed()) {
            focusControl.getShell().open();
            return focusControl.getShell();
        }
        Shell shell = display.getActiveShell();
        if (shell != null) {
            return shell;
        }
        Shell[] shells = display.getShells();
        if (shells != null) {
            Shell[] shellArray = shells;
            int n = shells.length;
            int n2 = 0;
            while (n2 < n) {
                Shell topShell = shellArray[n2];
                if (topShell != controlShell) {
                    topShell.open();
                    return topShell;
                }
                ++n2;
            }
        }
        return null;
    }

    public static void collectImage(Control control, ImageCollectedRunnable imageRunnable) {
        if (control == null || control.isDisposed() || imageRunnable == null) {
            return;
        }
        Rectangle bounds = control.getBounds();
        if (bounds.isEmpty()) {
            imageRunnable.imageNotCollected();
        } else {
            Image image = null;
            if (control instanceof Shell || control instanceof ToolBar || SWTUtil.IsGTK) {
                Shell shell = null;
                if (control instanceof Shell) {
                    shell = (Shell)control;
                } else {
                    shell = control.getShell();
                    shell.pack();
                    shell.setLocation(0, 0);
                    while (control.getDisplay().readAndDispatch()) {
                    }
                }
                bounds = control.getBounds();
                shell.setAlpha(0);
                if (SWTUtil.IsCocoa) {
                    if (!shell.isVisible()) {
                        shell.open();
                    }
                } else {
                    shell.moveBelow(null);
                    if (!shell.isVisible()) {
                        shell.setVisible(true);
                    }
                }
                if (control instanceof Shell) {
                    image = ImageCapture.getInstance().capture(control, bounds.width, bounds.height, true);
                } else {
                    image = new Image((Device)control.getDisplay(), bounds.width, bounds.height);
                    GC gc = new GC((Drawable)image);
                    control.print(gc);
                    gc.dispose();
                }
                shell.setVisible(false);
            } else {
                image = new Image((Device)control.getDisplay(), bounds.width, bounds.height);
                GC gc = new GC((Drawable)image);
                control.print(gc);
                gc.dispose();
            }
            if (image != null) {
                imageRunnable.imageCollected(image);
            } else {
                imageRunnable.imageNotCollected();
            }
        }
    }

    private static void saveImage(Image image, String path) {
        ImageLoader imageLoader = new ImageLoader();
        ImageData imageData = image.getImageData();
        imageLoader.data = new ImageData[]{imageData};
        imageLoader.save(path, 4);
    }
}

