/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.parts;

public class RefreshContext {
    public static final int REFRESH_IMAGE = 1;
    public static final int REFRESH_CHILDREN = 2;
    public static final int REFRESH_VISUALS = 4;
    public static final int REFRESH_ALL = 7;
    private int refreshType = 0;

    RefreshContext(int refreshType) {
        this.refreshType = refreshType;
    }

    public boolean refreshImage() {
        return this.refresh(1);
    }

    public void setImageRefreshed() {
        this.setRefreshed(1);
    }

    public boolean refreshChildren() {
        return this.refresh(2);
    }

    public void setVisualsRefreshed() {
        this.setRefreshed(4);
    }

    public void setChildrenRefreshed() {
        this.setRefreshed(2);
    }

    public boolean refreshVisuals() {
        return this.refresh(4);
    }

    public int getRefreshType() {
        return this.refreshType;
    }

    public void setRefreshed(int type) {
        this.refreshType ^= type;
    }

    public boolean refresh(int type) {
        return (this.refreshType & type) != 0;
    }

    public static final RefreshContext ALL() {
        return RefreshContext.createRefreshContext(7);
    }

    public static final RefreshContext IMAGE() {
        return RefreshContext.createRefreshContext(1);
    }

    public static final RefreshContext CHILDREN() {
        return RefreshContext.createRefreshContext(2);
    }

    public static final RefreshContext VISUALS() {
        return RefreshContext.createRefreshContext(4);
    }

    public static final RefreshContext createRefreshContext(int refreshType) {
        return new RefreshContext(refreshType);
    }
}

