/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.editor.text;

import java.lang.reflect.Method;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.FormatProcessorsExtensionReader;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class StructuredTextHelper {
    public static final String CONTENT_TYPE = "content-type.xaml";

    public static void format(IDocument document) {
        if (document instanceof IStructuredDocument) {
            IStructuredDocument structDocument = (IStructuredDocument)document;
            IStructuredModel model = StructuredModelManager.getModelManager().getModelForEdit(structDocument);
            IStructuredFormatProcessor processor = StructuredTextHelper.getFormatProcessor(CONTENT_TYPE);
            if (model != null && processor != null) {
                processor.formatModel(model);
            }
        }
    }

    protected static IStructuredFormatProcessor getFormatProcessor(String contentTypeId) {
        return FormatProcessorsExtensionReader.getInstance().getFormatProcessor(contentTypeId);
    }

    public static int getOffsetAtPoint(ITextViewer textViewer, Point absolutePosition) {
        StyledText styledText = textViewer.getTextWidget();
        Point relativePosition = styledText.toControl(absolutePosition);
        try {
            Method method = StyledText.class.getDeclaredMethod("getOffsetAtPoint", Integer.TYPE, Integer.TYPE, int[].class, Boolean.TYPE);
            method.setAccessible(true);
            int[] trailing = new int[1];
            int widgetOffset = (Integer)method.invoke((Object)styledText, relativePosition.x, relativePosition.y, trailing, false);
            return widgetOffset += trailing[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IDOMNode getCurrentNode(ITextViewer textViewer, Point absolutePosition) {
        return StructuredTextHelper.getNode(textViewer, StructuredTextHelper.getOffsetAtPoint(textViewer, absolutePosition));
    }

    public static IDOMNode getNode(ITextViewer textViewer, int documentPosition) {
        return (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)textViewer, (int)documentPosition);
    }

    public static ITextRegion getCompletionRegion(int documentPosition, Node domnode) {
        if (domnode == null) {
            return null;
        }
        ITextRegion region = null;
        int offset = documentPosition;
        IStructuredDocumentRegion flatNode = null;
        IDOMNode node = (IDOMNode)domnode;
        if (node.getNodeType() == 9) {
            if (node.getStructuredDocument().getLength() == 0) {
                return null;
            }
            ITextRegion result = node.getStructuredDocument().getRegionAtCharacterOffset(offset).getRegionAtCharacterOffset(offset);
            while (result == null) {
                result = node.getStructuredDocument().getRegionAtCharacterOffset(--offset).getRegionAtCharacterOffset(offset);
            }
            return result;
        }
        IStructuredDocumentRegion startTag = node.getStartStructuredDocumentRegion();
        IStructuredDocumentRegion endTag = node.getEndStructuredDocumentRegion();
        if (startTag != null && startTag.getStartOffset() <= offset && offset < startTag.getStartOffset() + startTag.getLength()) {
            flatNode = startTag;
        } else if (endTag != null && endTag.getStartOffset() <= offset && offset < endTag.getStartOffset() + endTag.getLength()) {
            flatNode = endTag;
        }
        region = flatNode != null ? StructuredTextHelper.getCompletionRegion(offset, flatNode) : ((flatNode = node.getStructuredDocument().getRegionAtCharacterOffset(offset)).getStartOffset() <= documentPosition && flatNode.getEndOffset() >= documentPosition ? (offset == flatNode.getStartOffset() && flatNode.getPrevious() != null && (flatNode.getRegionAtCharacterOffset(documentPosition) != null && flatNode.getRegionAtCharacterOffset(documentPosition).getType() != "XML_CONTENT" || flatNode.getPrevious().getLastRegion().getType() == "XML_TAG_OPEN" || flatNode.getPrevious().getLastRegion().getType() == "XML_END_TAG_OPEN") ? flatNode.getPrevious().getLastRegion() : (flatNode.getEndOffset() == documentPosition ? flatNode.getLastRegion() : flatNode.getFirstRegion())) : flatNode.getLastRegion());
        return region;
    }

    protected static ITextRegion getCompletionRegion(int offset, IStructuredDocumentRegion sdRegion) {
        ITextRegion nextRegion;
        ITextRegion previousRegion;
        ITextRegion region = sdRegion.getRegionAtCharacterOffset(offset);
        if (region == null) {
            return null;
        }
        if (sdRegion.getStartOffset(region) == offset) {
            if (sdRegion.getStartOffset(region) == sdRegion.getStartOffset() && sdRegion.getPrevious() != null && !sdRegion.getPrevious().isEnded()) {
                region = sdRegion.getPrevious().getRegionAtCharacterOffset(offset - 1);
            } else {
                previousRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
                if (previousRegion != null && previousRegion != region && previousRegion.getTextLength() == previousRegion.getLength()) {
                    region = previousRegion;
                }
            }
        } else if (offset > sdRegion.getStartOffset(region) + region.getTextLength() && (nextRegion = sdRegion.getRegionAtCharacterOffset(sdRegion.getStartOffset(region) + region.getLength())) != null) {
            region = nextRegion;
        }
        if (region != null && region.getType() == "WHITE_SPACE" && (previousRegion = sdRegion.getRegionAtCharacterOffset(sdRegion.getStartOffset(region) - 1)) != null) {
            region = previousRegion;
        }
        return region;
    }
}

